/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.transfer.ITransferRegistry;
import org.squiddev.plethora.core.ConverterRegistry;
import org.squiddev.plethora.core.MetaRegistry;

public class PartialContext<T>
implements IPartialContext<T> {
    protected final int target;
    protected final String[] keys;
    protected final Object[] values;
    protected final ICostHandler handler;
    protected final IModuleContainer modules;

    public PartialContext(int target, String[] keys, @Nonnull Object[] values, @Nonnull ICostHandler handler, @Nonnull IModuleContainer modules) {
        this.target = target;
        this.keys = keys;
        this.handler = handler;
        this.values = values;
        this.modules = modules;
    }

    @Override
    @Nonnull
    public T getTarget() {
        return (T)this.values[this.target];
    }

    PartialContext<?> withIndex(int index) {
        return index == this.target ? this : new PartialContext<T>(index, this.keys, this.values, this.handler, this.modules);
    }

    @Override
    public <V> V getContext(@Nonnull Class<V> klass) {
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i = this.values.length - 1; i >= 0; --i) {
            Object obj = this.values[i];
            if (!klass.isInstance(obj)) continue;
            return (V)obj;
        }
        return null;
    }

    @Override
    public <V> boolean hasContext(@Nonnull Class<V> klass) {
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i = this.values.length - 1; i >= 0; --i) {
            Object obj = this.values[i];
            if (!klass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <V> V getContext(@Nonnull String contextKey, @Nonnull Class<V> klass) {
        Objects.requireNonNull(contextKey, "contextKey cannot be null");
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i = this.values.length - 1; i >= 0; --i) {
            Object obj = this.values[i];
            if (!contextKey.equals(this.keys[i]) || !klass.isInstance(obj)) continue;
            return (V)obj;
        }
        return null;
    }

    @Override
    public <V> boolean hasContext(@Nonnull String contextKey, @Nonnull Class<V> klass) {
        Objects.requireNonNull(klass, "klass cannot be null");
        for (int i = this.values.length - 1; i >= 0; --i) {
            Object obj = this.values[i];
            if (!contextKey.equals(this.keys[i]) || !klass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public <U> PartialContext<U> makePartialChild(@Nonnull U target) {
        Objects.requireNonNull(target, "target cannot be null");
        ArrayList<String> keys = new ArrayList<String>(this.keys.length + 1);
        ArrayList<Object> values = new ArrayList<Object>(this.values.length + 1);
        Collections.addAll(keys, this.keys);
        Collections.addAll(values, this.values);
        for (int i = keys.size() - 1; i >= 0; --i) {
            if (!"target".equals(keys.get(i))) continue;
            keys.set(i, "generic");
        }
        keys.add("target");
        values.add(target);
        ConverterRegistry.instance.extendConverted(keys, values, this.values.length);
        return new PartialContext<T>(this.values.length, keys.toArray(new String[0]), values.toArray(), this.handler, this.modules);
    }

    @Override
    @Nonnull
    public ICostHandler getCostHandler() {
        return this.handler;
    }

    @Override
    @Nullable
    public Object getTransferLocation(@Nonnull String key) {
        int i;
        Objects.requireNonNull(key, "key cannot be null");
        String[] parts = key.split("\\.");
        String primary = parts[0];
        ITransferRegistry registry = PlethoraAPI.instance().transferRegistry();
        Object found = null;
        for (i = this.values.length - 1; i >= 0 && (found = registry.getTransferPart(this.values[i], primary, false)) == null; --i) {
        }
        if (found == null) {
            return null;
        }
        for (i = 1; i < parts.length; ++i) {
            if ((found = registry.getTransferPart(found, parts[i], true)) != null) continue;
            return null;
        }
        return found;
    }

    @Override
    @Nonnull
    public Set<String> getTransferLocations() {
        ITransferRegistry registry = PlethoraAPI.instance().transferRegistry();
        HashSet<String> out = new HashSet<String>(registry.getTransferLocations(this.target, true));
        for (int i = this.values.length - 1; i >= 0; --i) {
            out.addAll(registry.getTransferLocations(this.values[i], true));
        }
        return out;
    }

    @Override
    @Nonnull
    public IModuleContainer getModules() {
        return this.modules;
    }

    @Override
    @Nonnull
    public TypedMeta<T, ?> getMeta() {
        return MetaRegistry.instance.getMeta(this);
    }
}

