/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.TileBase;
import org.squiddev.plethora.utils.Helpers;

public abstract class BlockBase<T extends TileBase>
extends BlockContainer {
    public final String name;
    public final Class<T> klass;

    public BlockBase(String blockName, Material material, Class<T> klass) {
        super(material);
        this.klass = klass;
        this.name = blockName;
        this.setRegistryName(new ResourceLocation("plethora", blockName));
        this.func_149711_c(2.0f);
        this.func_149663_c("plethora." + blockName);
        this.func_149647_a(Plethora.getCreativeTab());
    }

    public BlockBase(String name, Class<T> klass) {
        this(name, Material.field_151576_e, klass);
    }

    @Nullable
    public T getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return (T)((Object)(this.klass.isInstance(tile) ? (TileBase)tile : null));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        T tile = this.getTile((IBlockAccess)world, pos);
        return tile != null && ((TileBase)((Object)tile)).onActivated(player, hand, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, neighborBlock, fromPos);
        if (world.field_72995_K) {
            return;
        }
        T tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            ((TileBase)((Object)tile)).onNeighborChanged();
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        if (world instanceof World && ((World)world).field_72995_K) {
            return;
        }
        T tile = this.getTile(world, pos);
        if (tile != null) {
            ((TileBase)((Object)tile)).onNeighborChanged();
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos block, @Nonnull IBlockState state) {
        T tile;
        if (!world.field_72995_K && (tile = this.getTile((IBlockAccess)world, block)) != null) {
            ((TileBase)((Object)tile)).broken();
        }
        super.func_180663_b(world, block, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> out, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, out, advanced);
        out.add(Helpers.translateToLocal(this.getTranslationKey(stack.func_77952_i()) + ".desc"));
    }

    public String getTranslationKey(int meta) {
        return this.func_149739_a();
    }
}

