/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object3d;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.client.FramebufferGlasses;
import org.squiddev.plethora.gameplay.client.OpenGlHelper;
import org.squiddev.plethora.gameplay.client.RenderState;
import org.squiddev.plethora.gameplay.modules.glasses.BaseObject;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ObjectGroup;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.DepthTestable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Positionable3D;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object3d.Rotatable3D;
import org.squiddev.plethora.utils.ByteBufUtils;

public class ObjectFrame
extends BaseObject
implements ObjectGroup.Frame2D,
Positionable3D,
Rotatable3D,
DepthTestable {
    private static final float SCALE = 0.015625f;
    private Vec3d position = Vec3d.field_186680_a;
    private Vec3d rotation = null;
    private boolean depthTest = true;

    public ObjectFrame(int id, int parent) {
        super(id, parent, (byte)10);
    }

    @Override
    @Nonnull
    public Vec3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec3d position) {
        if (!this.position.equals((Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    @Override
    @Nullable
    public Vec3d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(@Nullable Vec3d rotation) {
        if (!Objects.equals(this.rotation, rotation)) {
            this.rotation = rotation;
            this.setDirty();
        }
    }

    @Override
    public boolean hasDepthTest() {
        return this.depthTest;
    }

    @Override
    public void setDepthTest(boolean depthTest) {
        if (this.depthTest != depthTest) {
            this.depthTest = depthTest;
            this.setDirty();
        }
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        ByteBufUtils.writeVec3d(buf, this.position);
        ByteBufUtils.writeOptVec3d(buf, this.rotation);
        buf.writeBoolean(this.depthTest);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        this.position = ByteBufUtils.readVec3d(buf);
        this.rotation = ByteBufUtils.readOptVec3d(buf);
        this.depthTest = buf.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        IntSet children = canvas.getChildren(this.id());
        if (children == null) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderManager renderManager = minecraft.func_175598_ae();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.position.field_72450_a, (double)this.position.field_72448_b, (double)this.position.field_72449_c);
        GlStateManager.func_179152_a((float)0.015625f, (float)-0.015625f, (float)0.015625f);
        if (this.rotation == null) {
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)((float)this.rotation.field_72450_a), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.rotation.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)this.rotation.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderState state = RenderState.get();
        if (OpenGlHelper.field_148823_f) {
            FramebufferGlasses.FRAME_3D.bindBuffer();
            FramebufferGlasses.FRAME_3D.setupViewport();
            FramebufferGlasses.clear();
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)512.0, (double)288.0, (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
        GlStateManager.func_179126_j();
        canvas.drawChildren(children.iterator());
        if (OpenGlHelper.field_148823_f) {
            state.restore();
            GlStateManager.func_179098_w();
            GlStateManager.func_179129_p();
            GlStateManager.func_179147_l();
            if (this.depthTest) {
                GlStateManager.func_179126_j();
            } else {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            FramebufferGlasses.FRAME_3D.bindTexture();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(0.0, 288.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(512.0, 288.0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(512.0, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179144_i((int)0);
        }
        GlStateManager.func_179121_F();
    }
}

