/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.ConstantConverter;
import org.squiddev.plethora.integration.PlethoraIntegration;

@Injects(value="computercraft")
public final class ConverterTargetedPeripheral
implements ConstantConverter<IPeripheral, Object> {
    private boolean fetched;
    private Class<?> multiPeripheral;
    private Field multiPeripheralPeripherals;
    private Class<?> wrappedMultiPeripheral;
    private Field wrappedMultiPeripheralPeripheral;

    private void fetchReflection() {
        if (this.fetched) {
            return;
        }
        try {
            this.multiPeripheral = Class.forName("pl.asie.computronics.cc.multiperipheral.MultiPeripheral");
            this.multiPeripheralPeripherals = this.multiPeripheral.getDeclaredField("peripherals");
            this.multiPeripheralPeripherals.setAccessible(true);
            this.wrappedMultiPeripheral = Class.forName("pl.asie.computronics.api.multiperipheral.WrappedMultiPeripheral");
            this.wrappedMultiPeripheralPeripheral = this.wrappedMultiPeripheral.getDeclaredField("peripheral");
            this.wrappedMultiPeripheralPeripheral.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        this.fetched = true;
    }

    @Override
    @Nullable
    public Object convert(@Nonnull IPeripheral from) {
        this.fetchReflection();
        Object to = from.getTarget();
        if (from != to) {
            return to;
        }
        if (this.multiPeripheral != null && this.multiPeripheralPeripherals != null && this.multiPeripheral.isInstance(from)) {
            try {
                List peripherals = (List)this.multiPeripheralPeripherals.get(from);
                for (IPeripheral child : peripherals) {
                    IPeripheral wrapped;
                    if (child != (to = child.getTarget())) {
                        return to;
                    }
                    if (this.wrappedMultiPeripheral == null || this.wrappedMultiPeripheralPeripheral == null || !this.wrappedMultiPeripheral.isInstance(child) || (wrapped = (IPeripheral)this.wrappedMultiPeripheralPeripheral.get(child)) == (to = wrapped.getTarget())) continue;
                    return to;
                }
            }
            catch (ReflectiveOperationException e) {
                PlethoraIntegration.LOG.error("Cannot extract peripherals from multi-peripheral", (Throwable)e);
            }
        }
        if (this.wrappedMultiPeripheral != null && this.wrappedMultiPeripheralPeripheral != null && this.wrappedMultiPeripheral.isInstance(from)) {
            try {
                IPeripheral wrapped = (IPeripheral)this.wrappedMultiPeripheralPeripheral.get(from);
                to = wrapped.getTarget();
                if (wrapped != to) {
                    return to;
                }
            }
            catch (ReflectiveOperationException e) {
                PlethoraIntegration.LOG.error("Cannot extract peripherals from multi-peripheral", (Throwable)e);
            }
        }
        return null;
    }
}

