/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.integration.jei.UseInRecipeCategory;
import org.squiddev.plethora.integration.jei.UseInRecipeWrapper;

public final class ModulesWrapper
extends UseInRecipeWrapper {
    private static final String ID = "modules";
    private static final ItemStack[] STACKS = new ItemStack[]{new ItemStack((Item)Registration.itemNeuralInterface), new ItemStack((Block)Registration.blockManipulator, 1, 0), new ItemStack((Block)Registration.blockManipulator, 1, 1)};

    private ModulesWrapper(@Nonnull ItemStack stack, @Nonnull IGuiHelper helper) {
        super(stack, ID, STACKS, helper);
    }

    @Override
    public boolean isValid() {
        return ModulesWrapper.isValid(this.stack);
    }

    private static boolean isValid(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(Constants.MODULE_HANDLER_CAPABILITY, null);
    }

    public static void setup(IModRegistry registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        ArrayList wrappers = Lists.newArrayList();
        for (ItemStack stack : registry.getIngredientRegistry().getAllIngredients(VanillaTypes.ITEM)) {
            if (!ModulesWrapper.isValid(stack)) continue;
            wrappers.add(new ModulesWrapper(stack, helper));
        }
        registry.addRecipes((Collection)wrappers, "plethora-core:modules");
        for (ItemStack stack : STACKS) {
            registry.addRecipeCatalyst((Object)stack, new String[]{"plethora-core:modules"});
        }
    }

    public static void setup(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new UseInRecipeCategory(ID, registry.getJeiHelpers().getGuiHelper())});
    }
}

