/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.config;

import net.machinemuse.numina.basemod.MuseLogger;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="numina", name="/machinemuse/numina")
public class NuminaSettings {
    public static General general = new General();

    @Mod.EventBusSubscriber(modid="numina")
    public class ConfigSyncHandler {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("numina")) {
                ConfigManager.load((String)"numina", (Config.Type)Config.Type.INSTANCE);
                MuseLogger.logger.info("Configuration has been saved.");
            }
        }
    }

    public static class General {
        @Config.LangKey(value="config.numina.useFOVFix")
        @Config.Comment(value={"Ignore speed boosts for field of view"})
        public boolean useFOVFix = true;
        @Config.LangKey(value="config.numina.FOVFixDefaultState")
        @Config.Comment(value={"Default state of FOVfix on login (enabled = true, disabled = false)"})
        public boolean fovFixDefaultState = true;
        @Config.LangKey(value="config.numina.useSounds")
        @Config.Comment(value={"Use sounds"})
        public boolean useSounds = true;
        @Config.LangKey(value="config.numina.useDebuggingInfo")
        @Config.Comment(value={"Debugging info"})
        public boolean isDebugging = false;
        @Config.LangKey(value="config.numina.mekanismJToRFRatio")
        @Config.Comment(value={"Mekanism Joules equals how many RF"})
        public double mekRatio = 0.4;
        @Config.LangKey(value="config.numina.industrialCraft2ToRFRatio")
        @Config.Comment(value={"IndustrialCraft2 EU equals how many RF"})
        @Config.RequiresWorldRestart
        public double ic2Ratio = 4.0;
        @Config.LangKey(value="config.numina.refinedStorageToRFRatio")
        @Config.Comment(value={"Refined PlayerFOVStateStorage  energy equals how many RF"})
        @Config.RequiresWorldRestart
        public double rsRatio = 1.0;
        @Config.LangKey(value="config.numina.appledEnergisticsToRFRatio")
        @Config.Comment(value={"Applied Energistics AE energy equals how many RF"})
        @Config.RequiresWorldRestart
        public double ae2Ratio = 2.0;
        @Config.LangKey(value="config.numina.tier1EnergyLevel")
        @Config.Comment(value={"Maximum amount of RF energy for Tier 1."})
        @Config.RangeInt(min=0)
        public int maxTier1 = (int)(1.0 * Math.pow(10.0, 6.0));
        @Config.LangKey(value="config.numina.tier2EnergyLevel")
        @Config.Comment(value={"Maximum amount of RF energy for Tier 2."})
        @Config.RangeInt(min=0)
        public int maxTier2 = (int)(5.0 * Math.pow(10.0, 6.0));
        @Config.LangKey(value="config.numina.tier3EnergyLevel")
        @Config.Comment(value={"Maximum amount of RF energy for Tier 3."})
        @Config.RangeInt(min=0)
        public int maxTier3 = (int)(5.0 * Math.pow(10.0, 7.0));
        @Config.LangKey(value="config.numina.tier4EnergyLevel")
        @Config.Comment(value={"Maximum amount of RF energy for Tier 4."})
        @Config.RangeInt(min=0)
        public int maxTier4 = (int)(1.0 * Math.pow(10.0, 8.0));
    }
}

