/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import com.google.common.collect.Lists;
import cubex2.cs4.CustomStuff4;
import cubex2.cs4.plugins.vanilla.BlockDrop;
import cubex2.cs4.plugins.vanilla.ContentBlockBase;
import cubex2.cs4.plugins.vanilla.ContentBlockBaseWithSubtypes;
import cubex2.cs4.plugins.vanilla.ContentGuiBase;
import cubex2.cs4.plugins.vanilla.GuiRegistry;
import cubex2.cs4.plugins.vanilla.TileEntityRegistry;
import cubex2.cs4.plugins.vanilla.block.CSBlock;
import cubex2.cs4.util.IntRange;
import cubex2.cs4.util.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;

public abstract class BlockMixin
extends Block
implements CSBlock<ContentBlockBase> {
    public static final AxisAlignedBB DEFAULT_AABB_MARKER = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BlockMixin(Material materialIn) {
        super(materialIn);
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        return this.getContent().slipperiness.get(this.getSubtype(state)).orElse(Float.valueOf(0.6f)).floatValue();
    }

    public int func_180651_a(IBlockState state) {
        return this.getSubtype(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Optional<BlockDrop[]> blockDrops = this.getContent().drop.get(this.getSubtype(state));
        if (blockDrops.isPresent()) {
            drops.addAll(ItemHelper.getDroppedStacks(blockDrops.get(), fortune));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return this.getContent().canSilkHarvest.get(this.getSubtype(state)).orElse(true);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        Item item = Item.func_150898_a((Block)this);
        int subtype = 0;
        if (item.func_77614_k()) {
            subtype = this.getSubtype(state);
        }
        return new ItemStack(item, 1, subtype);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return this.getContent().harvestTool.get(this.getSubtype(state)).orElse(null);
    }

    public int getHarvestLevel(IBlockState state) {
        return this.getContent().harvestLevel.get(this.getSubtype(state)).orElse(-1);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.getContent().isFullCube.get(this.getSubtype(state)).orElse(true);
    }

    public boolean func_149662_c(IBlockState state) {
        if (this.getContent() == null) {
            return true;
        }
        return this.getContent().isOpaqueCube.get(this.getSubtype(state)).orElse(true);
    }

    public BlockRenderLayer func_180664_k() {
        BlockRenderLayer layer = this.getContent().renderLayer;
        return layer != null ? layer : super.func_180664_k();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getContent().hardness.get(this.getSubtype(blockState)).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState blockState = world.func_180495_p(pos);
        return this.getContent().resistance.get(this.getSubtype(blockState)).orElse(Float.valueOf(0.0f)).floatValue() / 5.0f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.getContent().soundType.get(this.getSubtype(state)).orElse(SoundType.field_185851_d);
    }

    public int func_149717_k(IBlockState state) {
        return this.getContent().opacity.get(this.getSubtype(state)).orElse(255);
    }

    public int func_149750_m(IBlockState state) {
        return this.getContent().light.get(this.getSubtype(state)).orElse(0);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().flammability.get(this.getSubtype(state)).orElse(0) * 3;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().fireSpreadSpeed.get(this.getSubtype(state)).orElse(0);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().isFireSource.get(this.getSubtype(state)).orElse(false);
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().isWood.get(this.getSubtype(state)).orElse(false);
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getContent().canSustainLeaves.get(this.getSubtype(state)).orElse(false);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType type = plantable.getPlantType(world, pos.func_177972_a(direction));
        Object[] sustainedPlants = this.getContent().sustainedPlants.get(this.getSubtype(state)).orElse(null);
        if (sustainedPlants != null) {
            return ArrayUtils.contains((Object[])sustainedPlants, (Object)type);
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().isBeaconBase.get(this.getSubtype(state)).orElse(false);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().enchantPowerBonus.get(this.getSubtype(state)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.getContent().expDrop.get(this.getSubtype(state)).orElse(IntRange.ZERO).getRandomValue();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.getContent().mapColor.get(this.getSubtype(state)).orElse(this.func_149688_o(state).func_151565_r());
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.getContent().isBurning.get(this.getSubtype(state)).orElse(false);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN && !this.getContent().canPlaceOnCeiling) {
            return false;
        }
        if (side == EnumFacing.UP && !this.getContent().canPlaceOnFloor) {
            return false;
        }
        if (side.func_176740_k().func_176722_c() && !this.getContent().canPlaceOnSides) {
            return false;
        }
        return super.func_176198_a(worldIn, pos, side);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB bounds = this.getContent().bounds.get(this.getSubtype(state)).orElse(DEFAULT_AABB_MARKER);
        return bounds == DEFAULT_AABB_MARKER ? super.func_185496_a(state, source, pos) : bounds;
    }

    @Nullable
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        AxisAlignedBB bounds = this.getContent().selectionBounds.get(this.getSubtype(state)).orElse(null);
        if (bounds == DEFAULT_AABB_MARKER) {
            return super.func_180640_a(state, worldIn, pos);
        }
        return bounds != null ? bounds.func_186670_a(pos) : null;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.getContent().collisionBounds == null) {
            return null;
        }
        AxisAlignedBB bounds = this.getContent().collisionBounds.get(this.getSubtype(state)).orElse(null);
        if (bounds == DEFAULT_AABB_MARKER) {
            return super.func_180646_a(state, worldIn, pos);
        }
        return bounds;
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        String[] lines = this.getContent().information.get(stack.func_77960_j()).orElse(new String[0]);
        tooltip.addAll(Arrays.asList(lines));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.addAll(ItemHelper.createSubItems(Item.func_150898_a((Block)this), tab, this.getContent().creativeTab, this.getSubtypes()));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        PathNodeType nodeType = this.getContent().pathNodeType.get(this.getSubtype(state)).orElse(null);
        if (nodeType == null) {
            return super.getAiPathNodeType(state, world, pos);
        }
        return nodeType;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        Boolean isWeb = this.getContent().isWeb.get(this.getSubtype(state)).orElse(false);
        if (isWeb.booleanValue()) {
            entityIn.func_70110_aj();
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    public boolean hasTileEntity(IBlockState state) {
        int subtype = this.getSubtype(state);
        return this.getContent().tileEntity.hasEntry(subtype) && this.getContent().tileEntity.get(subtype).isPresent();
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.hasTileEntity(state)) {
            Optional<ResourceLocation> optional = this.getContent().tileEntity.get(this.getSubtype(state));
            if (optional.isPresent()) {
                return TileEntityRegistry.createTileEntity(optional.get());
            }
            return null;
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            if (this.interactWithFluidItem(worldIn, pos, state, playerIn, hand, facing)) {
                return true;
            }
            if (this.openGui(worldIn, pos, state, playerIn)) {
                return true;
            }
        } else {
            if (this.openGui(worldIn, pos, state, playerIn)) {
                return true;
            }
            if (this.interactWithFluidItem(worldIn, pos, state, playerIn, hand, facing)) {
                return true;
            }
        }
        return false;
    }

    private boolean interactWithFluidItem(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing) {
        TileEntity tile;
        if (this.getContent().canInteractWithFluidItem.get(this.getSubtype(state)).orElse(true).booleanValue() && (tile = worldIn.func_175625_s(pos)) != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            if (worldIn.field_72995_K) {
                return true;
            }
            if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)facing)) {
                playerIn.field_71069_bz.func_75142_b();
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IItemHandler itemHandler;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private boolean openGui(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        Optional<ContentGuiBase> gui = this.getGui(state);
        if (gui.isPresent()) {
            if (worldIn.field_72995_K) {
                return true;
            }
            playerIn.openGui((Object)CustomStuff4.INSTANCE, gui.get().getGuiId(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    private Optional<ContentGuiBase> getGui(IBlockState state) {
        Optional<ResourceLocation> location = this.getContent().gui.get(this.getSubtype(state));
        if (location.isPresent()) {
            ContentGuiBase gui = GuiRegistry.get(location.get());
            if (gui == null) {
                FMLLog.warning((String)"Missing GUI %s", (Object[])new Object[]{location.get()});
            }
            return Optional.ofNullable(gui);
        }
        return Optional.empty();
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer superState = super.func_180661_e();
        ArrayList superProperties = Lists.newArrayList((Iterable)superState.func_177623_d());
        superProperties.addAll(Arrays.asList(this.getProperties()));
        if (superState instanceof ExtendedBlockState) {
            IUnlistedProperty[] unlistedProperties = ((ExtendedBlockState)superState).getUnlistedProperties().toArray(new IUnlistedProperty[0]);
            return new ExtendedBlockState((Block)this, ContentBlockBaseWithSubtypes.insertSubtype(superProperties), unlistedProperties);
        }
        return new BlockStateContainer((Block)this, ContentBlockBaseWithSubtypes.insertSubtype(superProperties));
    }
}

