/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.plugins.vanilla.crafting.MachineManager;
import cubex2.cs4.plugins.vanilla.gui.ItemFilter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilterDeserializer
implements JsonDeserializer<ItemFilter> {
    public ItemFilter deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return this.fromString(json.getAsString(), context);
        }
        if (json.isJsonArray()) {
            return this.combinedFilterOr(json.getAsJsonArray(), context);
        }
        if (json.isJsonObject()) {
            return new StackFilter((WrappedItemStack)context.deserialize(json, WrappedItemStack.class));
        }
        throw new JsonParseException("Invalid item filter: " + json.toString());
    }

    private ItemFilter fromString(String input, JsonDeserializationContext context) {
        if (input.startsWith("machineInput:")) {
            ResourceLocation recipeList = (ResourceLocation)context.deserialize((JsonElement)new JsonPrimitive(input.substring("machineInput:".length())), ResourceLocation.class);
            return stack -> MachineManager.isPartOfRecipe(recipeList, stack);
        }
        if (input.startsWith("machineFuel:")) {
            ResourceLocation recipeList = (ResourceLocation)context.deserialize((JsonElement)new JsonPrimitive(input.substring("machineFuel:".length())), ResourceLocation.class);
            return stack -> MachineManager.isPartOfFuel(recipeList, stack);
        }
        if (input.startsWith("ore:")) {
            String oreName = input.substring("ore:".length());
            return stack -> OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)oreName), (ItemStack[])new ItemStack[]{stack});
        }
        WrappedItemStack wrappedStack = (WrappedItemStack)context.deserialize((JsonElement)new JsonPrimitive(input), WrappedItemStack.class);
        return new StackFilter(wrappedStack);
    }

    private ItemFilter combinedFilterOr(JsonArray array, JsonDeserializationContext context) {
        ArrayList filters = Lists.newArrayList();
        for (int i = 0; i < array.size(); ++i) {
            ItemFilter filter = (ItemFilter)context.deserialize(array.get(i), ItemFilter.class);
            filters.add(filter);
        }
        return stack -> filters.stream().anyMatch(f -> f.accepts(stack));
    }

    static class StackFilter
    implements ItemFilter {
        private final WrappedItemStack wrappedStack;
        private ItemStack itemStack = ItemStack.field_190927_a;

        StackFilter(WrappedItemStack wrappedStack) {
            this.wrappedStack = wrappedStack;
        }

        @Override
        public boolean accepts(ItemStack stack) {
            if (this.itemStack == ItemStack.field_190927_a) {
                this.itemStack = this.wrappedStack.getItemStack();
            }
            return !this.itemStack.func_190926_b() && OreDictionary.itemMatches((ItemStack)this.itemStack, (ItemStack)stack, (boolean)false);
        }
    }
}

