/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.jei;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import trinsdar.ic2c_extras.Ic2cExtrasConfig;
import trinsdar.ic2c_extras.util.recipelists.FluidCanningRecipeList;

public class JeiFluidCanningWrapper
extends BlankRecipeWrapper {
    FluidCanningRecipeList.FluidCanningRecipe entry;

    public JeiFluidCanningWrapper(FluidCanningRecipeList.FluidCanningRecipe recipe) {
        this.entry = recipe;
    }

    public void getIngredients(IIngredients components) {
        components.setInputLists(ItemStack.class, Arrays.asList(this.entry.getInput().getInputs()));
        if (this.entry.hasFluidInput()) {
            components.setInputs(FluidStack.class, Arrays.asList(this.entry.getInputFluid()));
        }
        ArrayList<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
        if (this.entry.hasItemOutput()) {
            int count = 0;
            for (ItemStack stack : this.entry.getOutputs().copy().getAllOutputs()) {
                outputs.add(Arrays.asList(stack));
                if (++count < 1) continue;
                break;
            }
            components.setOutputLists(ItemStack.class, outputs);
        }
        if (this.entry.hasFluidOutput()) {
            components.setOutput(FluidStack.class, (Object)this.entry.getOutputFluid());
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer font = minecraft.field_71466_p;
        if (Ic2cExtrasConfig.debugMode) {
            font.func_78276_b("Recipe Id: " + this.entry.getRecipeID(), 5, 62, Color.black.getRGB());
        }
    }
}

