/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;

public class UnloadDimensionRangeSubCommand
extends BasePregenCommand {
    public UnloadDimensionRangeSubCommand() {
        super(2);
        this.addDescription(0, "Min Range: The Lowest Value of Dimension that should be unloaded");
        this.addDescription(1, "Max Value: The Highest Value of Dimension that should be unloaded");
        this.addSuggestion("unloadDimensionRange -1 1", "Unloads the End & The Nether");
        this.addSuggestion("unloadDimensionRange -1100 -1000", "Unloads all the GalacticCraft Dimensions");
    }

    @Override
    public String getName() {
        return "unloadDimensionRange";
    }

    @Override
    public String getDescription() {
        return "Unloads a Range of Loaded-Dimensions";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            int second;
            int first = UnloadDimensionRangeSubCommand.parseNumber(args[0], 0);
            if (first == (second = UnloadDimensionRangeSubCommand.parseNumber(args[1], 0))) {
                container.sendChatMessage("Error First & Second Numbers can not be the same");
                return;
            }
            int min = Math.min(first, second);
            int max = Math.max(first, second);
            HashSet<Integer> allDims = new HashSet<Integer>(Arrays.asList(DimensionManager.getIDs()));
            allDims.remove(0);
            ArrayList<Integer> unloadedDims = new ArrayList<Integer>();
            for (int i = min; i <= max; ++i) {
                if (!allDims.contains(i)) continue;
                DimensionManager.unloadWorld((int)i);
                unloadedDims.add(i);
            }
            container.sendChatMessage("Unloaded Dimensions: " + unloadedDims);
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0 || commandIndex == 1) {
            return UnloadDimensionRangeSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }
}

