/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import java.util.LinkedList;

public class TimeTracker {
    LinkedList<Long> allValues = new LinkedList();
    int limit;
    long start = 0L;
    long average = 0L;
    long last = 0L;

    public TimeTracker(int limit) {
        this.limit = limit;
    }

    public void setStart() {
        this.start = System.nanoTime();
    }

    public void onFinished() {
        long value = System.nanoTime() - this.start;
        this.allValues.add(value);
        this.average += value;
        this.start = 0L;
        this.last = value;
        if (this.allValues.size() > this.limit) {
            this.average -= this.allValues.removeFirst().longValue();
        }
    }

    public long getLastValue() {
        return this.last;
    }

    public long getAverage() {
        return this.allValues.isEmpty() ? 0L : this.average / (long)this.allValues.size();
    }

    public void clear() {
        this.allValues.clear();
        this.average = 0L;
        this.start = 0L;
        this.last = 0L;
    }
}

