/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.DataMutateResult;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.LocalizedNode;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.NodeEqualityPredicate;
import me.lucko.luckperms.api.TemporaryDataMutateResult;
import me.lucko.luckperms.api.TemporaryMergeBehaviour;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.caching.CachedData;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface PermissionHolder {
    public @NonNull String getObjectName();

    public @NonNull String getFriendlyName();

    public @NonNull CachedData getCachedData();

    public @NonNull CompletableFuture<Void> refreshCachedData();

    public @NonNull ImmutableSetMultimap<ImmutableContextSet, Node> getNodes();

    public @NonNull ImmutableSetMultimap<ImmutableContextSet, Node> getTransientNodes();

    public @NonNull List<Node> getOwnNodes();

    public @NonNull SortedSet<? extends Node> getPermissions();

    public @NonNull Set<? extends Node> getEnduringPermissions();

    public @NonNull Set<? extends Node> getTransientPermissions();

    public @NonNull Set<Node> getPermanentPermissionNodes();

    public @NonNull Set<Node> getTemporaryPermissionNodes();

    public @NonNull List<LocalizedNode> resolveInheritances(@NonNull Contexts var1);

    public @NonNull List<LocalizedNode> resolveInheritances();

    public @NonNull SortedSet<LocalizedNode> getAllNodes(@NonNull Contexts var1);

    public @NonNull SortedSet<LocalizedNode> getAllNodes();

    public @NonNull Set<LocalizedNode> getAllNodesFiltered(@NonNull Contexts var1);

    public @NonNull Map<String, Boolean> exportNodes(@NonNull Contexts var1, boolean var2);

    public void auditTemporaryPermissions();

    public @NonNull Tristate hasPermission(@NonNull Node var1, @NonNull NodeEqualityPredicate var2);

    public @NonNull Tristate hasTransientPermission(@NonNull Node var1, @NonNull NodeEqualityPredicate var2);

    public @NonNull Tristate inheritsPermission(@NonNull Node var1, @NonNull NodeEqualityPredicate var2);

    public @NonNull Tristate hasPermission(@NonNull Node var1);

    public @NonNull Tristate hasTransientPermission(@NonNull Node var1);

    public @NonNull Tristate inheritsPermission(@NonNull Node var1);

    public boolean inheritsGroup(@NonNull Group var1);

    public boolean inheritsGroup(@NonNull Group var1, @NonNull ContextSet var2);

    public @NonNull DataMutateResult setPermission(@NonNull Node var1);

    public @NonNull TemporaryDataMutateResult setPermission(@NonNull Node var1, @NonNull TemporaryMergeBehaviour var2);

    public @NonNull DataMutateResult setTransientPermission(@NonNull Node var1);

    public @NonNull TemporaryDataMutateResult setTransientPermission(@NonNull Node var1, @NonNull TemporaryMergeBehaviour var2);

    public @NonNull DataMutateResult unsetPermission(@NonNull Node var1);

    public @NonNull DataMutateResult unsetTransientPermission(@NonNull Node var1);

    public void clearMatching(@NonNull Predicate<Node> var1);

    public void clearMatchingTransient(@NonNull Predicate<Node> var1);

    public void clearNodes();

    public void clearNodes(@NonNull ContextSet var1);

    public void clearParents();

    public void clearParents(@NonNull ContextSet var1);

    public void clearMeta();

    public void clearMeta(@NonNull ContextSet var1);

    public void clearTransientNodes();

    @Deprecated
    default public @NonNull DataMutateResult setPermissionUnchecked(@NonNull Node node) {
        return this.setPermission(node);
    }

    @Deprecated
    default public @NonNull DataMutateResult setTransientPermissionUnchecked(@NonNull Node node) {
        return this.setTransientPermission(node);
    }

    @Deprecated
    default public @NonNull DataMutateResult unsetPermissionUnchecked(@NonNull Node node) {
        return this.unsetPermission(node);
    }

    @Deprecated
    default public @NonNull DataMutateResult unsetTransientPermissionUnchecked(@NonNull Node node) {
        return this.unsetTransientPermission(node);
    }
}

