/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.calculators;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.calculators.PermissionCalculatorMetadata;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.processors.PermissionProcessor;
import me.lucko.luckperms.common.verbose.CheckOrigin;
import me.lucko.luckperms.lib.caffeine.cache.CacheLoader;
import me.lucko.luckperms.lib.caffeine.cache.Caffeine;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PermissionCalculator
implements CacheLoader<String, Tristate> {
    private final LuckPermsPlugin plugin;
    private final PermissionCalculatorMetadata metadata;
    private final ImmutableList<PermissionProcessor> processors;
    private final LoadingCache<String, Tristate> lookupCache = Caffeine.newBuilder().build((CacheLoader)this);

    public PermissionCalculator(LuckPermsPlugin plugin, PermissionCalculatorMetadata metadata, ImmutableList<PermissionProcessor> processors) {
        this.plugin = plugin;
        this.metadata = metadata;
        this.processors = processors;
    }

    public Tristate getPermissionValue(String permission, CheckOrigin origin) {
        permission = permission.toLowerCase();
        Tristate result = (Tristate)((Object)this.lookupCache.get((Object)permission));
        this.plugin.getVerboseHandler().offerCheckData(origin, this.metadata.getObjectName(), this.metadata.getContext(), permission, result);
        return result;
    }

    public Tristate load(@NonNull String permission) {
        this.plugin.getPermissionRegistry().offer(permission);
        for (PermissionProcessor processor : this.processors) {
            Tristate result = processor.hasPermission(permission);
            if (result == Tristate.UNDEFINED) continue;
            return result;
        }
        return Tristate.UNDEFINED;
    }

    public synchronized void setSourcePermissions(Map<String, Boolean> sourceMap) {
        for (PermissionProcessor processor : this.processors) {
            processor.setSource(sourceMap);
            processor.refresh();
        }
    }

    public List<PermissionProcessor> getProcessors() {
        return this.processors;
    }

    public void invalidateCache() {
        this.lookupCache.invalidateAll();
    }
}

