/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.contexts;

import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.buffers.ExpiringCache;
import me.lucko.luckperms.common.contexts.ContextManager;
import me.lucko.luckperms.common.contexts.ContextsSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ContextsCache<T>
extends ExpiringCache<Contexts>
implements ContextsSupplier {
    private final T subject;
    private final ContextManager<T> contextManager;

    public ContextsCache(T subject, ContextManager<T> contextManager) {
        super(50L, TimeUnit.MILLISECONDS);
        this.subject = subject;
        this.contextManager = contextManager;
    }

    @Override
    protected @NonNull Contexts supply() {
        return this.contextManager.calculate(this.subject);
    }

    @Override
    public Contexts getContexts() {
        return (Contexts)this.get();
    }

    @Override
    public ImmutableContextSet getContextSet() {
        return ((Contexts)this.get()).getContexts().makeImmutable();
    }
}

