/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Optional;
import java.util.OptionalInt;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.nodetype.types.DisplayNameType;
import me.lucko.luckperms.common.api.delegates.model.ApiGroup;
import me.lucko.luckperms.common.buffers.Cache;
import me.lucko.luckperms.common.caching.GroupCachedData;
import me.lucko.luckperms.common.model.DisplayNameCache;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.Identifiable;
import me.lucko.luckperms.common.model.NodeMapType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.WeightCache;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class Group
extends PermissionHolder
implements Identifiable<String> {
    private final ApiGroup apiDelegate = new ApiGroup(this);
    private final String name;
    private final Cache<OptionalInt> weightCache = new WeightCache(this);
    private final Cache<Optional<String>> displayNameCache = new DisplayNameCache(this);
    private final GroupCachedData cachedData;

    public Group(String name, LuckPermsPlugin plugin) {
        super(plugin);
        this.name = name.toLowerCase();
        this.cachedData = new GroupCachedData(this);
        this.getPlugin().getEventFactory().handleGroupCacheLoad(this, this.cachedData);
    }

    @Override
    protected void invalidateCache() {
        super.invalidateCache();
        this.weightCache.invalidate();
        this.displayNameCache.invalidate();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getFormattedDisplayName() {
        Optional<String> dn = this.getDisplayName();
        return dn.map(s -> this.name + " &r(" + s + "&r)").orElse(this.name);
    }

    @Override
    public String getPlainDisplayName() {
        return this.getDisplayName().orElse(this.getName());
    }

    public Optional<String> getDisplayName() {
        return this.displayNameCache.get();
    }

    public Optional<String> getDisplayName(ContextSet contextSet) {
        for (Node n : this.getData(NodeMapType.ENDURING).immutable().get((Object)contextSet.makeImmutable())) {
            Optional<DisplayNameType> displayName = n.getTypeData(DisplayNameType.KEY);
            if (!displayName.isPresent()) continue;
            return Optional.of(displayName.get().getDisplayName());
        }
        return Optional.empty();
    }

    public ApiGroup getApiDelegate() {
        return this.apiDelegate;
    }

    public GroupCachedData getCachedData() {
        return this.cachedData;
    }

    @Override
    public OptionalInt getWeight() {
        return this.weightCache.get();
    }

    @Override
    public HolderType getType() {
        return HolderType.GROUP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Group(name=" + this.name + ")";
    }
}

