/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.comparator;

import java.util.Comparator;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.common.contexts.ContextSetComparator;
import me.lucko.luckperms.common.node.comparator.NodeComparator;

public class NodeWithContextComparator
implements Comparator<Node> {
    private static final Comparator<? super Node> INSTANCE = new NodeWithContextComparator();
    private static final Comparator<? super Node> REVERSE = INSTANCE.reversed();

    public static Comparator<? super Node> normal() {
        return INSTANCE;
    }

    public static Comparator<? super Node> reverse() {
        return REVERSE;
    }

    private NodeWithContextComparator() {
    }

    @Override
    public int compare(Node o1, Node o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Boolean.compare(o1.isOverride(), o2.isOverride());
        if (result != 0) {
            return result;
        }
        result = ContextSetComparator.normal().compare(o1.getFullContexts().makeImmutable(), o2.getFullContexts().makeImmutable());
        if (result != 0) {
            return result;
        }
        return NodeComparator.normal().compare(o1, o2);
    }
}

