/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.factory;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.api.Node;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.node.model.ImmutableNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NodeBuilder
implements Node.Builder {
    protected String permission;
    private ImmutableContextSet.Builder extraContexts = ImmutableContextSet.builder();
    private Boolean value = true;
    private boolean override = false;
    private String server = null;
    private String world = null;
    private long expireAt = 0L;

    NodeBuilder() {
    }

    NodeBuilder(String permission) {
        this.permission = permission;
    }

    public NodeBuilder(Node other) {
        this.permission = other.getPermission();
        this.copyFrom(other);
    }

    @Override
    public Node.Builder copyFrom(@NonNull Node node) {
        Objects.requireNonNull(node, "node");
        this.value = node.getValue();
        this.override = node.isOverride();
        this.server = node.getServer().orElse(null);
        this.world = node.getWorld().orElse(null);
        this.expireAt = node.isPermanent() ? 0L : node.getExpiryUnixTime();
        this.extraContexts = ImmutableContextSet.builder().addAll(node.getContexts());
        return this;
    }

    @Override
    public @NonNull Node.Builder setNegated(boolean negated) {
        this.value = !negated;
        return this;
    }

    @Override
    public @NonNull Node.Builder setValue(boolean value) {
        this.value = value;
        return this;
    }

    @Override
    public @NonNull Node.Builder setOverride(boolean override) {
        this.override = override;
        return this;
    }

    @Override
    public @NonNull Node.Builder setExpiry(long expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @Override
    public @NonNull Node.Builder clearExpiry() {
        this.expireAt = 0L;
        return this;
    }

    @Override
    public @NonNull Node.Builder setWorld(String world) {
        this.world = world;
        return this;
    }

    @Override
    public @NonNull Node.Builder setServer(String server) {
        this.server = server;
        return this;
    }

    @Override
    public @NonNull Node.Builder withExtraContext(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        switch (key.toLowerCase()) {
            case "server": {
                this.setServer(value);
                break;
            }
            case "world": {
                this.setWorld(value);
                break;
            }
            default: {
                this.extraContexts.add(key, value);
            }
        }
        return this;
    }

    @Override
    public @NonNull Node.Builder withExtraContext(@NonNull Map.Entry<String, String> entry) {
        Objects.requireNonNull(entry, "entry");
        this.withExtraContext(entry.getKey(), entry.getValue());
        return this;
    }

    @Override
    public @NonNull Node.Builder withExtraContext(@NonNull Map<String, String> map) {
        Objects.requireNonNull(map, "map");
        this.withExtraContext(ContextSet.fromMap(map));
        return this;
    }

    @Override
    public @NonNull Node.Builder withExtraContext(@NonNull Set<Map.Entry<String, String>> context) {
        Objects.requireNonNull(context, "context");
        this.withExtraContext(ContextSet.fromEntries(context));
        return this;
    }

    @Override
    public @NonNull Node.Builder withExtraContext(@NonNull ContextSet set) {
        Objects.requireNonNull(set, "set");
        set.toSet().forEach(this::withExtraContext);
        return this;
    }

    @Override
    public @NonNull Node.Builder setExtraContext(@NonNull ContextSet contextSet) {
        this.extraContexts = ImmutableContextSet.builder().addAll(contextSet);
        return this;
    }

    @Override
    public @NonNull Node build() {
        return new ImmutableNode(this.permission, this.value, this.override, this.expireAt, this.server, this.world, this.extraContexts.build());
    }
}

