/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.plugin;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.api.LuckPermsApi;
import me.lucko.luckperms.common.actionlog.LogDispatcher;
import me.lucko.luckperms.common.api.ApiRegistrationUtil;
import me.lucko.luckperms.common.api.LuckPermsApiProvider;
import me.lucko.luckperms.common.calculators.CalculatorFactory;
import me.lucko.luckperms.common.config.AbstractConfiguration;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.config.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.contexts.LPStaticContextsCalculator;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.DependencyManager;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.event.EventFactory;
import me.lucko.luckperms.common.inheritance.InheritanceHandler;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.messaging.MessagingFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.Storage;
import me.lucko.luckperms.common.storage.StorageFactory;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.storage.implementation.file.FileWatcher;
import me.lucko.luckperms.common.tasks.SyncTask;
import me.lucko.luckperms.common.treeview.PermissionRegistry;
import me.lucko.luckperms.common.verbose.VerboseHandler;

public abstract class AbstractLuckPermsPlugin
implements LuckPermsPlugin {
    private DependencyManager dependencyManager;
    private VerboseHandler verboseHandler;
    private PermissionRegistry permissionRegistry;
    private LogDispatcher logDispatcher;
    private LuckPermsConfiguration configuration;
    private LocaleManager localeManager;
    private FileWatcher fileWatcher = null;
    private Storage storage;
    private InternalMessagingService messagingService = null;
    private SyncTask.Buffer syncTaskBuffer;
    private InheritanceHandler inheritanceHandler;
    private CalculatorFactory calculatorFactory;
    private LuckPermsApiProvider apiProvider;
    private EventFactory eventFactory;

    public final void load() {
        this.dependencyManager = new DependencyManager(this);
        this.dependencyManager.loadDependencies(this.getGlobalDependencies());
        this.setupSenderFactory();
    }

    public final void enable() {
        this.displayBanner(this.getConsoleSender());
        this.verboseHandler = new VerboseHandler(this.getBootstrap().getScheduler());
        this.permissionRegistry = new PermissionRegistry(this.getBootstrap().getScheduler());
        this.logDispatcher = new LogDispatcher(this);
        this.getLogger().info("Loading configuration...");
        this.configuration = new AbstractConfiguration(this, this.provideConfigurationAdapter());
        this.localeManager = new LocaleManager();
        this.localeManager.tryLoad(this, this.getBootstrap().getConfigDirectory().resolve("lang.yml"));
        StorageFactory storageFactory = new StorageFactory(this);
        Set<StorageType> storageTypes = storageFactory.getRequiredTypes(StorageType.H2);
        this.dependencyManager.loadStorageDependencies(storageTypes);
        this.registerPlatformListeners();
        if (this.getConfiguration().get(ConfigKeys.WATCH_FILES).booleanValue()) {
            try {
                this.fileWatcher = new FileWatcher(this, this.getBootstrap().getDataDirectory());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.storage = storageFactory.getInstance(StorageType.H2);
        this.messagingService = this.provideMessagingFactory().getInstance();
        this.syncTaskBuffer = new SyncTask.Buffer(this);
        this.registerCommands();
        this.getLogger().info("Loading internal permission managers...");
        this.inheritanceHandler = new InheritanceHandler(this);
        this.setupManagers();
        this.calculatorFactory = this.provideCalculatorFactory();
        this.setupContextManager();
        this.getContextManager().registerStaticCalculator(new LPStaticContextsCalculator(this.getConfiguration()));
        this.setupPlatformHooks();
        this.apiProvider = new LuckPermsApiProvider(this);
        this.eventFactory = new EventFactory(this.provideEventBus(this.apiProvider));
        ApiRegistrationUtil.registerProvider(this.apiProvider);
        this.registerApiOnPlatform(this.apiProvider);
        int mins = this.getConfiguration().get(ConfigKeys.SYNC_TIME);
        if (mins > 0) {
            this.getBootstrap().getScheduler().asyncRepeating(() -> this.syncTaskBuffer.request(), mins, TimeUnit.MINUTES);
        }
        this.getLogger().info("Performing initial data load...");
        try {
            new SyncTask(this, true).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.registerHousekeepingTasks();
        this.performFinalSetup();
        this.getLogger().info("Successfully enabled. (took " + (System.currentTimeMillis() - this.getBootstrap().getStartupTime()) + "ms)");
    }

    public final void disable() {
        this.permissionRegistry.stop();
        this.verboseHandler.stop();
        this.removePlatformHooks();
        this.getLogger().info("Closing storage...");
        this.storage.shutdown();
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
        }
        if (this.messagingService != null) {
            this.getLogger().info("Closing messaging service...");
            this.messagingService.close();
        }
        ApiRegistrationUtil.unregisterProvider();
        this.getLogger().info("Shutting down internal scheduler...");
        this.getBootstrap().getScheduler().shutdown();
        this.getLogger().info("Goodbye!");
    }

    protected abstract void setupSenderFactory();

    protected abstract Set<Dependency> getGlobalDependencies();

    protected abstract ConfigurationAdapter provideConfigurationAdapter();

    protected abstract void registerPlatformListeners();

    protected abstract MessagingFactory<?> provideMessagingFactory();

    protected abstract void registerCommands();

    protected abstract void setupManagers();

    protected abstract CalculatorFactory provideCalculatorFactory();

    protected abstract void setupContextManager();

    protected abstract void setupPlatformHooks();

    protected abstract AbstractEventBus provideEventBus(LuckPermsApiProvider var1);

    protected abstract void registerApiOnPlatform(LuckPermsApi var1);

    protected abstract void registerHousekeepingTasks();

    protected abstract void performFinalSetup();

    protected void removePlatformHooks() {
    }

    @Override
    public PluginLogger getLogger() {
        return this.getBootstrap().getPluginLogger();
    }

    @Override
    public void setMessagingService(InternalMessagingService messagingService) {
        if (this.messagingService == null) {
            this.messagingService = messagingService;
        }
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public VerboseHandler getVerboseHandler() {
        return this.verboseHandler;
    }

    @Override
    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Override
    public LogDispatcher getLogDispatcher() {
        return this.logDispatcher;
    }

    @Override
    public LuckPermsConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    @Override
    public Optional<FileWatcher> getFileWatcher() {
        return Optional.ofNullable(this.fileWatcher);
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Optional<InternalMessagingService> getMessagingService() {
        return Optional.ofNullable(this.messagingService);
    }

    @Override
    public SyncTask.Buffer getSyncTaskBuffer() {
        return this.syncTaskBuffer;
    }

    @Override
    public InheritanceHandler getInheritanceHandler() {
        return this.inheritanceHandler;
    }

    @Override
    public CalculatorFactory getCalculatorFactory() {
        return this.calculatorFactory;
    }

    @Override
    public LuckPermsApiProvider getApiProvider() {
        return this.apiProvider;
    }

    @Override
    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    private void displayBanner(Sender sender) {
        sender.sendMessage(Message.colorize("&b       &3 __    "));
        sender.sendMessage(Message.colorize("&b  |    &3|__)   &2LuckPerms &bv" + this.getBootstrap().getVersion()));
        sender.sendMessage(Message.colorize("&b  |___ &3|      &8Running on " + this.getBootstrap().getType().getFriendlyName() + " - " + this.getBootstrap().getServerBrand()));
        sender.sendMessage("");
    }
}

