/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.plugin.bootstrap;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Stream;
import me.lucko.luckperms.api.platform.PlatformType;
import me.lucko.luckperms.common.dependencies.classloader.PluginClassLoader;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LuckPermsBootstrap {
    public PluginLogger getPluginLogger();

    public SchedulerAdapter getScheduler();

    public PluginClassLoader getPluginClassLoader();

    public CountDownLatch getLoadLatch();

    public CountDownLatch getEnableLatch();

    public String getVersion();

    public long getStartupTime();

    public PlatformType getType();

    public String getServerBrand();

    public String getServerVersion();

    default public @Nullable String getServerName() {
        return null;
    }

    public Path getDataDirectory();

    default public Path getConfigDirectory() {
        return this.getDataDirectory();
    }

    public InputStream getResourceStream(String var1);

    public Optional<?> getPlayer(UUID var1);

    public Optional<UUID> lookupUuid(String var1);

    public Optional<String> lookupUsername(UUID var1);

    public int getPlayerCount();

    public Stream<String> getPlayerList();

    public Stream<UUID> getOnlinePlayers();

    public boolean isPlayerOnline(UUID var1);
}

