/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.actionlog.LogEntryJsonSerializer;
import me.lucko.luckperms.common.buffers.BufferedRequest;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.utils.gson.GsonProvider;

public class FileActionLogger {
    private Path contentFile;
    private final ReentrantLock writeLock = new ReentrantLock();
    private final Queue<LogEntry> entryQueue = new ConcurrentLinkedQueue<LogEntry>();
    private final SaveBuffer saveBuffer;

    public FileActionLogger(LuckPermsPlugin plugin) {
        this.saveBuffer = new SaveBuffer(plugin);
    }

    public void init(Path contentFile) {
        this.contentFile = contentFile;
    }

    public void logAction(LogEntry entry) {
        this.entryQueue.add(entry);
        this.saveBuffer.request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.writeLock.lock();
        try {
            if (this.entryQueue.peek() == null) {
                return;
            }
            try {
                LogEntry e;
                JsonArray array;
                Throwable throwable;
                if (Files.exists(this.contentFile, new LinkOption[0])) {
                    try {
                        throwable = null;
                        try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(this.contentFile, StandardCharsets.UTF_8));){
                            array = GsonProvider.parser().parse(reader).getAsJsonArray();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        array = new JsonArray();
                    }
                } else {
                    array = new JsonArray();
                }
                while ((e = this.entryQueue.poll()) != null) {
                    array.add((JsonElement)LogEntryJsonSerializer.serialize(e));
                }
                throwable = null;
                try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(this.contentFile, StandardCharsets.UTF_8, new OpenOption[0]));){
                    writer.setIndent("  ");
                    GsonProvider.normal().toJson((JsonElement)array, writer);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Log getLog() throws IOException {
        Log.Builder log = Log.builder();
        try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(this.contentFile, StandardCharsets.UTF_8));){
            JsonArray array = GsonProvider.parser().parse(reader).getAsJsonArray();
            for (JsonElement element : array) {
                log.add(LogEntryJsonSerializer.deserialize(element));
            }
        }
        return log.build();
    }

    private final class SaveBuffer
    extends BufferedRequest<Void> {
        public SaveBuffer(LuckPermsPlugin plugin) {
            super(2L, TimeUnit.SECONDS, plugin.getBootstrap().getScheduler());
        }

        @Override
        protected Void perform() {
            FileActionLogger.this.flush();
            return null;
        }
    }
}

