/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.bulkupdate.comparisons.Constraint;
import me.lucko.luckperms.common.managers.group.GroupManager;
import me.lucko.luckperms.common.managers.track.TrackManager;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.Track;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import me.lucko.luckperms.common.node.model.NodeHeldPermission;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.file.AbstractConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.FileWatcher;
import me.lucko.luckperms.common.storage.implementation.file.StorageLocation;
import me.lucko.luckperms.common.storage.implementation.file.loader.ConfigurateLoader;
import me.lucko.luckperms.common.utils.MoreFiles;
import me.lucko.luckperms.common.utils.Uuids;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;

public class SeparatedConfigurateStorage
extends AbstractConfigurateStorage {
    private final String fileExtension;
    private Path usersDirectory;
    private Path groupsDirectory;
    private Path tracksDirectory;
    private FileWatcher.WatchedLocation userWatcher = null;
    private FileWatcher.WatchedLocation groupWatcher = null;
    private FileWatcher.WatchedLocation trackWatcher = null;

    public SeparatedConfigurateStorage(LuckPermsPlugin plugin, String implementationName, ConfigurateLoader loader, String fileExtension, String dataFolderName) {
        super(plugin, implementationName, loader, dataFolderName);
        this.fileExtension = fileExtension;
    }

    @Override
    protected ConfigurationNode readFile(StorageLocation location, String name) throws IOException {
        Path file = this.getDirectory(location).resolve(name + this.fileExtension);
        this.registerFileAction(location, file);
        return this.readFile(file);
    }

    private ConfigurationNode readFile(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        return this.loader.loader(file).load();
    }

    @Override
    protected void saveFile(StorageLocation location, String name, ConfigurationNode node) throws IOException {
        Path file = this.getDirectory(location).resolve(name + this.fileExtension);
        this.registerFileAction(location, file);
        this.saveFile(file, node);
    }

    private void saveFile(Path file, ConfigurationNode node) throws IOException {
        if (node == null) {
            Files.deleteIfExists(file);
            return;
        }
        this.loader.loader(file).save(node);
    }

    private Path getDirectory(StorageLocation location) {
        switch (location) {
            case USER: {
                return this.usersDirectory;
            }
            case GROUP: {
                return this.groupsDirectory;
            }
            case TRACK: {
                return this.tracksDirectory;
            }
        }
        throw new RuntimeException();
    }

    private Predicate<Path> getFileTypeFilter() {
        return path -> path.getFileName().toString().endsWith(this.fileExtension);
    }

    private void registerFileAction(StorageLocation type, Path file) {
        switch (type) {
            case USER: {
                if (this.userWatcher == null) break;
                this.userWatcher.recordChange(file.getFileName().toString());
                break;
            }
            case GROUP: {
                if (this.groupWatcher == null) break;
                this.groupWatcher.recordChange(file.getFileName().toString());
                break;
            }
            case TRACK: {
                if (this.trackWatcher == null) break;
                this.trackWatcher.recordChange(file.getFileName().toString());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.usersDirectory = MoreFiles.createDirectoryIfNotExists(this.dataDirectory.resolve("users"));
        this.groupsDirectory = MoreFiles.createDirectoryIfNotExists(this.dataDirectory.resolve("groups"));
        this.tracksDirectory = MoreFiles.createDirectoryIfNotExists(this.dataDirectory.resolve("tracks"));
        FileWatcher watcher = this.plugin.getFileWatcher().orElse(null);
        if (watcher != null) {
            this.userWatcher = watcher.getWatcher(this.usersDirectory);
            this.userWatcher.addListener(path -> {
                String s = path.getFileName().toString();
                if (!s.endsWith(this.fileExtension)) {
                    return;
                }
                String user = s.substring(0, s.length() - this.fileExtension.length());
                UUID uuid = Uuids.parse(user);
                if (uuid == null) {
                    return;
                }
                User u = this.plugin.getUserManager().getIfLoaded(uuid);
                if (u != null) {
                    this.plugin.getLogger().info("[FileWatcher] Detected change in user file for " + u.getPlainDisplayName() + " - reloading...");
                    this.plugin.getStorage().loadUser(uuid, null);
                }
            });
            this.groupWatcher = watcher.getWatcher(this.groupsDirectory);
            this.groupWatcher.addListener(path -> {
                String s = path.getFileName().toString();
                if (!s.endsWith(this.fileExtension)) {
                    return;
                }
                String groupName = s.substring(0, s.length() - this.fileExtension.length());
                this.plugin.getLogger().info("[FileWatcher] Detected change in group file for " + groupName + " - reloading...");
                this.plugin.getSyncTaskBuffer().request();
            });
            this.trackWatcher = watcher.getWatcher(this.tracksDirectory);
            this.trackWatcher.addListener(path -> {
                String s = path.getFileName().toString();
                if (!s.endsWith(this.fileExtension)) {
                    return;
                }
                String trackName = s.substring(0, s.length() - this.fileExtension.length());
                this.plugin.getLogger().info("[FileWatcher] Detected change in track file for " + trackName + " - reloading...");
                this.plugin.getStorage().loadAllTracks();
            });
        }
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws Exception {
        Throwable throwable;
        Stream<Path> s;
        if (bulkUpdate.getDataType().isIncludingUsers()) {
            s = Files.list(this.getDirectory(StorageLocation.USER));
            throwable = null;
            try {
                s.filter(this.getFileTypeFilter()).forEach(file -> {
                    try {
                        this.registerFileAction(StorageLocation.USER, (Path)file);
                        ConfigurationNode object = this.readFile((Path)file);
                        ConfigurationNode results = this.processBulkUpdate(bulkUpdate, object);
                        if (results != null) {
                            this.saveFile((Path)file, object);
                        }
                    }
                    catch (Exception e) {
                        throw this.reportException(file.getFileName().toString(), e);
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        if (bulkUpdate.getDataType().isIncludingGroups()) {
            s = Files.list(this.getDirectory(StorageLocation.GROUP));
            throwable = null;
            try {
                s.filter(this.getFileTypeFilter()).forEach(file -> {
                    try {
                        this.registerFileAction(StorageLocation.GROUP, (Path)file);
                        ConfigurationNode object = this.readFile((Path)file);
                        ConfigurationNode results = this.processBulkUpdate(bulkUpdate, object);
                        if (results != null) {
                            this.saveFile((Path)file, object);
                        }
                    }
                    catch (Exception e) {
                        throw this.reportException(file.getFileName().toString(), e);
                    }
                });
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() throws IOException {
        try (Stream<Path> stream = Files.list(this.usersDirectory);){
            Set<UUID> set = stream.filter(this.getFileTypeFilter()).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - this.fileExtension.length())).map(UUID::fromString).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public List<HeldPermission<UUID>> getUsersWithPermission(Constraint constraint) throws Exception {
        ArrayList<HeldPermission<UUID>> held = new ArrayList<HeldPermission<UUID>>();
        try (Stream<Path> stream = Files.list(this.getDirectory(StorageLocation.USER));){
            stream.filter(this.getFileTypeFilter()).forEach(file -> {
                String fileName = file.getFileName().toString();
                try {
                    this.registerFileAction(StorageLocation.USER, (Path)file);
                    ConfigurationNode object = this.readFile((Path)file);
                    UUID holder = UUID.fromString(fileName.substring(0, fileName.length() - this.fileExtension.length()));
                    Set<NodeDataContainer> nodes = SeparatedConfigurateStorage.readNodes(object);
                    for (NodeDataContainer e : nodes) {
                        if (!constraint.eval(e.getPermission())) continue;
                        held.add(NodeHeldPermission.of(holder, e));
                    }
                }
                catch (Exception e) {
                    throw this.reportException(file.getFileName().toString(), e);
                }
            });
        }
        return held;
    }

    @Override
    public void loadAllGroups() throws IOException {
        List groups;
        Stream<Path> stream = Files.list(this.groupsDirectory);
        Object object = null;
        try {
            groups = stream.filter(this.getFileTypeFilter()).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - this.fileExtension.length())).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        boolean success = true;
        for (String g2 : groups) {
            try {
                this.loadGroup(g2);
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
        }
        if (!success) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        GroupManager<? extends Group> gm = this.plugin.getGroupManager();
        gm.getAll().values().stream().filter(g -> !groups.contains(g.getName())).forEach(gm::unload);
    }

    @Override
    public List<HeldPermission<String>> getGroupsWithPermission(Constraint constraint) throws Exception {
        ArrayList<HeldPermission<String>> held = new ArrayList<HeldPermission<String>>();
        try (Stream<Path> stream = Files.list(this.getDirectory(StorageLocation.GROUP));){
            stream.filter(this.getFileTypeFilter()).forEach(file -> {
                String fileName = file.getFileName().toString();
                try {
                    this.registerFileAction(StorageLocation.GROUP, (Path)file);
                    ConfigurationNode object = this.readFile((Path)file);
                    String holder = fileName.substring(0, fileName.length() - this.fileExtension.length());
                    Set<NodeDataContainer> nodes = SeparatedConfigurateStorage.readNodes(object);
                    for (NodeDataContainer e : nodes) {
                        if (!constraint.eval(e.getPermission())) continue;
                        held.add(NodeHeldPermission.of(holder, e));
                    }
                }
                catch (Exception e) {
                    throw this.reportException(file.getFileName().toString(), e);
                }
            });
        }
        return held;
    }

    @Override
    public void loadAllTracks() throws IOException {
        List tracks;
        Stream<Path> stream = Files.list(this.tracksDirectory);
        Object object = null;
        try {
            tracks = stream.filter(this.getFileTypeFilter()).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - this.fileExtension.length())).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (object != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        boolean success = true;
        for (String t2 : tracks) {
            try {
                this.loadTrack(t2);
            }
            catch (Exception e) {
                e.printStackTrace();
                success = false;
            }
        }
        if (!success) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        TrackManager<? extends Track> tm = this.plugin.getTrackManager();
        tm.getAll().values().stream().filter(t -> !tracks.contains(t.getName())).forEach(tm::unload);
    }
}

