/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.utils;

import java.util.Calendar;
import java.util.GregorianCalendar;

public enum DurationFormatter {
    CONCISE{
        private final String[] names = new String[]{"y", "y", "m", "m", "d", "d", "h", "h", "m", "m", "s", "s"};

        @Override
        public String format(Calendar from, Calendar to) {
            return DurationFormatter.dateDiff(from, to, 4, this.names, true);
        }
    }
    ,
    CONCISE_LOW_ACCURACY{
        private final String[] names = new String[]{"y", "y", "m", "m", "d", "d", "h", "h", "m", "m", "s", "s"};

        @Override
        public String format(Calendar from, Calendar to) {
            return DurationFormatter.dateDiff(from, to, 2, this.names, true);
        }
    }
    ,
    LONG{
        private final String[] names = new String[]{"year", "years", "month", "months", "day", "days", "hour", "hours", "minute", "minutes", "second", "seconds"};

        @Override
        public String format(Calendar from, Calendar to) {
            return DurationFormatter.dateDiff(from, to, 4, this.names, false);
        }
    };

    private static final int[] CALENDAR_TYPES;
    private static final int MAX_YEARS = 100000;

    private static String dateDiff(Calendar from, Calendar to, int maxAccuracy, String[] names, boolean concise) {
        if (to.equals(from)) {
            return "now";
        }
        boolean future = to.after(from);
        StringBuilder sb = new StringBuilder();
        int accuracy = 0;
        for (int i = 0; i < CALENDAR_TYPES.length && accuracy <= maxAccuracy; ++i) {
            int diff = DurationFormatter.dateDiff(CALENDAR_TYPES[i], from, to, future);
            if (diff <= 0) continue;
            int plural = diff > 1 ? 1 : 0;
            String unit = names[i * 2 + plural];
            sb.append(" ");
            sb.append(diff);
            if (!concise) {
                sb.append(" ");
            }
            sb.append(unit);
            ++accuracy;
        }
        if (sb.length() == 0) {
            return "now";
        }
        return sb.toString().trim();
    }

    private static int dateDiff(int type, Calendar fromDate, Calendar toDate, boolean future) {
        int toYear;
        int fromYear = fromDate.get(1);
        if (Math.abs(fromYear - (toYear = toDate.get(1))) > 100000) {
            toDate.set(1, fromYear + (future ? 100000 : -100000));
        }
        int diff = 0;
        long savedDate = fromDate.getTimeInMillis();
        while (future && !fromDate.after(toDate) || !future && !fromDate.before(toDate)) {
            savedDate = fromDate.getTimeInMillis();
            fromDate.add(type, future ? 1 : -1);
            ++diff;
        }
        fromDate.setTimeInMillis(savedDate);
        return --diff;
    }

    public abstract String format(Calendar var1, Calendar var2);

    public String format(long seconds) {
        GregorianCalendar from = new GregorianCalendar();
        from.setTimeInMillis(0L);
        GregorianCalendar to = new GregorianCalendar();
        to.setTimeInMillis(seconds * 1000L);
        return this.format(from, to);
    }

    public String formatDateDiff(long unixTimestamp) {
        long now = System.currentTimeMillis() / 1000L;
        return this.format(unixTimestamp - now);
    }

    static {
        CALENDAR_TYPES = new int[]{1, 2, 5, 11, 12, 13};
    }
}

