/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.sponge.service.context.DelegatingContextSet;
import me.lucko.luckperms.sponge.service.context.DelegatingImmutableContextSet;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.util.Tristate;

public final class CompatibilityUtil {
    private static final Set<Context> EMPTY = ImmutableSet.of();

    public static ImmutableContextSet convertContexts(Set<Context> contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (contexts instanceof DelegatingContextSet) {
            return ((DelegatingContextSet)contexts).getDelegate().makeImmutable();
        }
        if (contexts.isEmpty()) {
            return ImmutableContextSet.empty();
        }
        return ImmutableContextSet.fromEntries(contexts);
    }

    public static Set<Context> convertContexts(ContextSet contexts) {
        Objects.requireNonNull(contexts, "contexts");
        if (contexts.isEmpty()) {
            return EMPTY;
        }
        return new DelegatingImmutableContextSet(contexts.makeImmutable());
    }

    public static Tristate convertTristate(me.lucko.luckperms.api.Tristate tristate) {
        Objects.requireNonNull(tristate, "tristate");
        switch (tristate) {
            case TRUE: {
                return Tristate.TRUE;
            }
            case FALSE: {
                return Tristate.FALSE;
            }
        }
        return Tristate.UNDEFINED;
    }

    public static me.lucko.luckperms.api.Tristate convertTristate(Tristate tristate) {
        Objects.requireNonNull(tristate, "tristate");
        switch (tristate) {
            case TRUE: {
                return me.lucko.luckperms.api.Tristate.TRUE;
            }
            case FALSE: {
                return me.lucko.luckperms.api.Tristate.FALSE;
            }
        }
        return me.lucko.luckperms.api.Tristate.UNDEFINED;
    }

    private CompatibilityUtil() {
    }
}

