/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.context;

import java.util.Iterator;
import java.util.Map;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.sponge.service.context.AbstractDelegatingContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.context.Context;

public class DelegatingImmutableContextSet
extends AbstractDelegatingContextSet {
    private final ImmutableContextSet delegate;

    public DelegatingImmutableContextSet(ImmutableContextSet delegate) {
        this.delegate = delegate;
    }

    @Override
    public ImmutableContextSet getDelegate() {
        return this.delegate;
    }

    @Override
    public @NonNull Iterator<Context> iterator() {
        return new ContextSetIterator();
    }

    @Override
    public boolean add(Context context) {
        throw new UnsupportedOperationException("context set is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("context set is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("context set is immutable");
    }

    @Override
    public String toString() {
        return "DelegatingImmutableContextSet(delegate=" + this.getDelegate() + ")";
    }

    private final class ContextSetIterator
    implements Iterator<Context> {
        private final Iterator<Map.Entry<String, String>> it;

        private ContextSetIterator() {
            this.it = DelegatingImmutableContextSet.this.delegate.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Context next() {
            Map.Entry<String, String> next = this.it.next();
            return new Context(next.getKey(), next.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("context set is immutable");
        }
    }
}

