/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.helper;

import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;

public final class PlayerHelper {
    public static boolean hasAnyHeldItem(EntityPlayer player) {
        return !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
    }

    public static boolean hasHeldItem(EntityPlayer player, Item item) {
        return !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == item || !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == item;
    }

    public static boolean hasHeldItemClass(EntityPlayer player, Item template) {
        return PlayerHelper.hasHeldItemClass(player, template.getClass());
    }

    public static boolean hasHeldItemClass(EntityPlayer player, Class<?> template) {
        return !player.func_184614_ca().func_190926_b() && template.isAssignableFrom(player.func_184614_ca().func_77973_b().getClass()) || !player.func_184592_cb().func_190926_b() && template.isAssignableFrom(player.func_184592_cb().func_77973_b().getClass());
    }

    public static ItemStack getFirstHeldItem(EntityPlayer player, Item item) {
        ItemStack main = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        if (!main.func_190926_b() && item == main.func_77973_b()) {
            return main;
        }
        if (!offhand.func_190926_b() && item == offhand.func_77973_b()) {
            return offhand;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getFirstHeldItemClass(EntityPlayer player, Class<?> template) {
        ItemStack main = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        if (!main.func_190926_b() && template.isAssignableFrom(main.func_77973_b().getClass())) {
            return main;
        }
        if (!offhand.func_190926_b() && template.isAssignableFrom(offhand.func_77973_b().getClass())) {
            return offhand;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getAmmo(EntityPlayer player, Predicate<ItemStack> ammoFunc) {
        if (ammoFunc.test(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (ammoFunc.test(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!ammoFunc.test(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean hasAmmo(EntityPlayer player, Predicate<ItemStack> ammoFunc) {
        return !PlayerHelper.getAmmo(player, ammoFunc).func_190926_b();
    }

    public static void consumeAmmo(EntityPlayer player, Predicate<ItemStack> ammoFunc) {
        ItemStack ammo = PlayerHelper.getAmmo(player, ammoFunc);
        if (!ammo.func_190926_b()) {
            ammo.func_190918_g(1);
        }
    }

    public static boolean hasItem(EntityPlayer player, Predicate<ItemStack> itemFunc) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!itemFunc.test(player.field_71071_by.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public static void grantCriterion(EntityPlayerMP player, ResourceLocation advancementId, String criterion) {
        PlayerAdvancements advancements = player.func_192039_O();
        AdvancementManager manager = player.func_71121_q().func_191952_z();
        Advancement advancement = manager.func_192778_a(advancementId);
        if (advancement != null) {
            advancements.func_192750_a(advancement, criterion);
        }
    }

    private PlayerHelper() {
    }
}

