/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropLumilia
extends CropCardBase {
    public CropLumilia() {
        super(new CropProperties(6, 3, 0, 0, 1, 0));
    }

    @Override
    public String getDiscoveredBy() {
        return "Daenara";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[88];
        }
        return this.getSprite("bc")[31 + state];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Yellow", "Leaves", "Flower"};
    }

    @Override
    public int getEmittedLight(ICropTile crop) {
        return crop.getCurrentSize() == 4 ? 15 : 0;
    }

    @Override
    public String getId() {
        return "Lumilia";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 || cropTile.getCurrentSize() == 3 && cropTile.getLightLevel() < 2;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack((Block)Blocks.field_150362_t);
    }

    @Override
    public double dropGainChance() {
        return super.dropGainChance() * 2.0;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 50;
        }
        return 800;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

