/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropSeedDropBase;
import ic2.core.platform.textures.Ic2Icons;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropSapling
extends CropSeedDropBase {
    String name;
    ItemStack gain;
    ItemStack seed;
    int textureIndex;

    public CropSapling(int index, String id, ItemStack item, ItemStack sapling) {
        super(new CropProperties(3, 1, 0, 4, 4, 0));
        this.gain = item.func_77946_l();
        this.textureIndex = index;
        this.name = id;
        this.seed = sapling;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state < 4) {
            return Ic2Icons.getTextures("bc")[68 + state];
        }
        return Ic2Icons.getTextures("bc")[this.textureIndex + (state - 4)];
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 5 && cropTile.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 5;
    }

    @Override
    public int getMaxSize() {
        return 5;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 4;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() >= 4) {
            return 150;
        }
        return super.getGrowthDuration(cropTile);
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return this.gain.func_77946_l();
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return this.seed.func_77946_l();
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Leaves", "Sapling", "Green"};
    }
}

