/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import ic2.api.item.ICustomDamageItem;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

public class ToolHelper {
    static Random rand = new Random();
    public static Item.ToolMaterial bronzeToolMaterial;
    public static ItemArmor.ArmorMaterial bronzeArmorMaterial;
    public static ItemArmor.ArmorMaterial compositeArmorMaterial;
    public static EntityBoat.Type boatRubber;
    public static EntityBoat.Type boatCarbon;

    public static boolean isToolEffective(IBlockState state, ItemStack stack) {
        String tool = state.func_177230_c().getHarvestTool(state);
        if (stack.func_190926_b() || tool == null) {
            return false;
        }
        return stack.func_77973_b().getHarvestLevel(stack, tool, null, state) >= state.func_177230_c().getHarvestLevel(state);
    }

    public static void setDamage(ItemStack stack, int damage) {
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof ICustomDamageItem) {
            ICustomDamageItem custom = (ICustomDamageItem)stack.func_77973_b();
            custom.setCustomDamage(stack, damage);
            return;
        }
        stack.func_77964_b(damage);
    }

    public static int getDamage(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ICustomDamageItem) {
            return ((ICustomDamageItem)stack.func_77973_b()).getCustomDamage(stack);
        }
        return stack.func_77952_i();
    }

    public static int getMaxDamage(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ICustomDamageItem) {
            return ((ICustomDamageItem)stack.func_77973_b()).getMaxCustomDamage(stack);
        }
        return stack.func_77958_k();
    }

    public static int getFreeDamage(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ICustomDamageItem) {
            ICustomDamageItem item = (ICustomDamageItem)stack.func_77973_b();
            return item.getMaxCustomDamage(stack) - item.getCustomDamage(stack);
        }
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public static double getPercentage(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0.0;
        }
        if (stack.func_77973_b() instanceof ICustomDamageItem) {
            ICustomDamageItem item = (ICustomDamageItem)stack.func_77973_b();
            return (double)item.getCustomDamage(stack) / (double)item.getMaxCustomDamage(stack);
        }
        return (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    public static boolean damageItem(ItemStack stack, int amount, EntityLivingBase entity) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ICustomDamageItem) {
            return ((ICustomDamageItem)stack.func_77973_b()).applyCustomDamage(stack, amount, entity);
        }
        if (entity == null) {
            return stack.func_96631_a(amount, rand, null);
        }
        stack.func_77972_a(amount, entity);
        return stack.func_77952_i() > stack.func_77958_k();
    }

    public static String blockStateToString(IBlockState state) {
        if (state == null) {
            return "normal";
        }
        Collection list = state.func_177227_a();
        if (list.isEmpty()) {
            return "normal";
        }
        String result = "";
        boolean first = true;
        for (IProperty prop : list) {
            if (!first) {
                result = result + ",";
            }
            first = false;
            result = result + prop.func_177701_a() + "=" + prop.func_177702_a(state.func_177229_b(prop));
        }
        return result;
    }

    public static IBlockState stringToBlockState(Block block, String state) {
        IBlockState defaultState = block.func_176223_P();
        IBlockState result = block.func_176223_P();
        if (state.equals("normal") || state.isEmpty()) {
            return result;
        }
        for (String entry : state.split(",")) {
            String[] array = entry.split("=");
            IProperty prop = ToolHelper.getProperty(defaultState, array[0]);
            if (prop == null) {
                return defaultState;
            }
            Comparable value = ToolHelper.getValue(prop, array[1]);
            if (value == null) {
                return defaultState;
            }
            result = result.func_177226_a(prop, value);
        }
        return result;
    }

    private static Comparable getValue(IProperty prop, String value) {
        for (Object entry : prop.func_177700_c()) {
            if (!prop.func_177702_a((Comparable)entry).equals(value)) continue;
            return (Comparable)entry;
        }
        return null;
    }

    private static IProperty getProperty(IBlockState state, String key) {
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals(key)) continue;
            return prop;
        }
        return null;
    }
}

