/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.client.gui;

import cf.terminator.laggoggles.client.ClientProxy;
import cf.terminator.laggoggles.client.ServerDataPacketHandler;
import cf.terminator.laggoggles.client.gui.GuiFPSResults;
import cf.terminator.laggoggles.client.gui.GuiInGameConfig;
import cf.terminator.laggoggles.client.gui.GuiScanResultsWorld;
import cf.terminator.laggoggles.client.gui.LagOverlayGui;
import cf.terminator.laggoggles.client.gui.buttons.DonateButton;
import cf.terminator.laggoggles.client.gui.buttons.DownloadButton;
import cf.terminator.laggoggles.client.gui.buttons.OptionsButton;
import cf.terminator.laggoggles.client.gui.buttons.ProfileButton;
import cf.terminator.laggoggles.packet.CPacketRequestResult;
import cf.terminator.laggoggles.packet.CPacketRequestScan;
import cf.terminator.laggoggles.packet.SPacketMessage;
import cf.terminator.laggoggles.profiler.ProfileManager;
import cf.terminator.laggoggles.profiler.ProfileResult;
import cf.terminator.laggoggles.profiler.ScanType;
import cf.terminator.laggoggles.util.Perms;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiProfile
extends GuiScreen {
    private static final int BUTTON_START_PROFILE_ID = 0;
    private static final int BUTTON_SHOW_TOGGLE = 1;
    private static final int BUTTON_ANALYZE_RESULTS = 2;
    private static final int LABEL_ID = 3;
    private static final int BUTTON_DONATE = 4;
    private static final int BUTTON_OPTIONS = 5;
    private static final int BUTTON_DOWNLOAD = 6;
    public static String PROFILING_PLAYER = null;
    public static long PROFILE_END_TIME = 0L;
    public static SPacketMessage MESSAGE = null;
    public static long MESSAGE_END_TIME = 0L;
    private ProfileButton startProfile;
    private DownloadButton downloadButton;
    private GuiButton optionsButton;
    private boolean initialized = false;
    public int seconds = Math.min(30, ServerDataPacketHandler.MAX_SECONDS);
    private Runnable buttonUpdateTask = new Runnable(){

        @Override
        public void run() {
            try {
                Thread.sleep(500L);
                if (!GuiProfile.isThisGuiOpen()) {
                    return;
                }
                GuiProfile.this.updateButton();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public static void update() {
        if (!GuiProfile.isThisGuiOpen()) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiProfile());
    }

    public static void open() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiProfile());
    }

    private static boolean isThisGuiOpen() {
        return Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiProfile;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n = new ArrayList();
        this.field_146293_o = new ArrayList();
        int centerX = this.field_146294_l / 2;
        int centerY = this.field_146295_m / 2;
        boolean profileLoaded = ProfileManager.LAST_PROFILE_RESULT.get() != null;
        this.startProfile = new ProfileButton(0, centerX - 100, centerY - 25, "Profile for " + this.seconds + " seconds");
        this.downloadButton = new DownloadButton(this, 6, centerX + 80, centerY - 25);
        this.optionsButton = new OptionsButton(5, centerX - 100, centerY + 75);
        GuiButton showToggle = new GuiButton(1, centerX - 100, centerY + 5, LagOverlayGui.isShowing() ? "Hide latest scan results" : "Show latest scan results");
        GuiButton analyzeResults = new GuiButton(2, centerX - 100, centerY + 30, "Analyze results");
        showToggle.field_146124_l = profileLoaded;
        analyzeResults.field_146124_l = profileLoaded;
        this.func_189646_b(this.startProfile);
        this.func_189646_b(showToggle);
        this.func_189646_b(analyzeResults);
        this.func_189646_b(new DonateButton(4, centerX + 10, centerY + 75));
        this.func_189646_b(this.optionsButton);
        GuiLabel scrollHint = new GuiLabel(this.field_146289_q, 3, centerX - 100, centerY - 55, 200, 20, 0xFFFFFF);
        scrollHint.func_175202_a("Scroll while hovering over the button");
        scrollHint.func_175202_a("to change time time!");
        this.field_146293_o.add(scrollHint);
        this.func_189646_b(this.downloadButton);
        this.initialized = true;
        this.updateButton();
    }

    private void updateButton() {
        if (!this.initialized) {
            return;
        }
        if (GuiProfile.getSecondsLeftForMessage() >= 0) {
            this.startProfile.field_146126_j = GuiProfile.MESSAGE.message;
            this.startProfile.field_146124_l = false;
            new Thread(this.buttonUpdateTask).start();
        } else if (GuiProfile.getSecondsLeftForProfiler() >= 0) {
            this.startProfile.field_146126_j = PROFILING_PLAYER + " > " + GuiProfile.getSecondsLeftForProfiler() + " seconds.";
            this.startProfile.field_146124_l = false;
            new Thread(this.buttonUpdateTask).start();
        } else {
            this.startProfile.field_146124_l = true;
            this.startProfile.field_146126_j = "Profile for " + this.seconds + " seconds";
        }
        this.downloadButton.field_146124_l = ServerDataPacketHandler.PERMISSION.ordinal() >= Perms.Permission.GET.ordinal();
    }

    private static int getSecondsLeftForProfiler() {
        if (PROFILING_PLAYER != null) {
            return new Double(Math.ceil((PROFILE_END_TIME - System.currentTimeMillis()) / 1000L)).intValue();
        }
        return -1;
    }

    public static int getSecondsLeftForMessage() {
        return new Double(Math.ceil((MESSAGE_END_TIME - System.currentTimeMillis()) / 1000L)).intValue();
    }

    public void func_146274_d() throws IOException {
        int wheel;
        if (!this.initialized) {
            return;
        }
        if (this.startProfile.func_146115_a() && this.startProfile.field_146124_l && (wheel = Mouse.getDWheel()) != 0) {
            this.seconds += wheel / 120 * 5;
            this.seconds = Math.max(this.seconds, 5);
            boolean triedMore = this.seconds > ServerDataPacketHandler.MAX_SECONDS;
            this.seconds = Math.min(this.seconds, ServerDataPacketHandler.MAX_SECONDS);
            this.startProfile.field_146126_j = triedMore ? "Limited to " + this.seconds + " seconds." : "Profile for " + this.seconds + " seconds";
        }
        super.func_146274_d();
        Mouse.getDWheel();
    }

    public void startProfile() {
        CPacketRequestScan scan = new CPacketRequestScan();
        scan.length = this.seconds;
        this.startProfile.field_146124_l = false;
        this.startProfile.field_146126_j = "Sending command...";
        ClientProxy.NETWORK_WRAPPER.sendToServer((IMessage)scan);
    }

    private void analyzeResults() {
        ProfileResult result = ProfileManager.LAST_PROFILE_RESULT.get();
        if (result != null) {
            if (result.getType() == ScanType.WORLD) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScanResultsWorld(result));
            } else if (result.getType() == ScanType.FPS) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiFPSResults(result));
            }
        }
    }

    public void func_146284_a(GuiButton gui) {
        switch (gui.field_146127_k) {
            case 0: {
                this.startProfile.click(this, this.field_146292_n);
                break;
            }
            case 1: {
                if (LagOverlayGui.isShowing()) {
                    LagOverlayGui.hide();
                    Minecraft.func_71410_x().func_147108_a(null);
                    break;
                }
                LagOverlayGui.show();
                Minecraft.func_71410_x().func_147108_a(null);
                break;
            }
            case 2: {
                this.analyzeResults();
                break;
            }
            case 4: {
                DonateButton.donate();
                break;
            }
            case 5: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiInGameConfig(this));
                break;
            }
            case 6: {
                ClientProxy.NETWORK_WRAPPER.sendToServer((IMessage)new CPacketRequestResult());
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public boolean func_73868_f() {
        return false;
    }
}

