/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IKeyListener;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public abstract class BasicScreen
extends MalisisGui {
    @Nullable
    protected final GuiScreen parent;
    private final boolean drawParentInBackground;

    public BasicScreen() {
        this(null);
    }

    public BasicScreen(@Nullable GuiScreen parent) {
        this(parent, false);
    }

    public BasicScreen(@Nullable GuiScreen parent, boolean drawParentInBackground) {
        this.parent = parent;
        this.drawParentInBackground = drawParentInBackground;
    }

    public static int getPaddedX(UIComponent<?> component, int padding) {
        return BasicScreen.getPaddedX(component, padding, Anchor.LEFT);
    }

    public static int getPaddedX(UIComponent<?> component, int padding, int anchor) {
        if (anchor == Anchor.LEFT) {
            return component.getX() + component.getWidth() + padding;
        }
        if (anchor == Anchor.RIGHT) {
            return component.getX() - component.getWidth() - padding;
        }
        throw new IllegalArgumentException("Invalid anchor used [" + anchor + "], anchor must be LEFT or RIGHT.");
    }

    public static int getPaddedY(UIComponent<?> component, int padding) {
        return BasicScreen.getPaddedY(component, padding, Anchor.TOP);
    }

    public static int getPaddedY(UIComponent<?> component, int padding, int anchor) {
        if (anchor == Anchor.BOTTOM) {
            return component.getY() - component.getHeight() - padding;
        }
        if (anchor == Anchor.TOP) {
            return component.getY() + component.getHeight() + padding;
        }
        throw new IllegalArgumentException("Invalid anchor used [" + anchor + "], anchor must be BOTTOM or TOP.");
    }

    public static int getPaddedWidth(UIComponent<? extends IScrollable> component) {
        return component.getWidth() - component.self().getLeftPadding() - component.self().getRightPadding();
    }

    public static int getPaddedHeight(UIComponent<? extends IScrollable> component) {
        return component.getHeight() - component.self().getTopPadding() - component.self().getBottomPadding();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        if (this.drawParentInBackground) {
            Optional.ofNullable(this.parent).ifPresent(screen -> screen.func_73863_a(mouseX, mouseY, partialTick));
        }
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public void func_73876_c() {
        if (this.drawParentInBackground) {
            Optional.ofNullable(this.parent).ifPresent(GuiScreen::func_73876_c);
        }
        super.func_73876_c();
    }

    public void func_175273_b(Minecraft minecraft, int width, int height) {
        if (this.drawParentInBackground) {
            Optional.ofNullable(this.parent).ifPresent(screen -> screen.func_175273_b(minecraft, width, height));
        }
        super.func_175273_b(minecraft, width, height);
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTick) {
        if (this.drawParentInBackground) {
            Optional.ofNullable(this.parent).filter(screen -> screen instanceof MalisisGui).ifPresent(screen -> ((MalisisGui)((Object)screen)).update(mouseX, mouseY, partialTick));
        }
        super.update(mouseX, mouseY, partialTick);
    }

    @Override
    public void updateGui() {
        if (this.drawParentInBackground) {
            Optional.ofNullable(this.parent).filter(screen -> screen instanceof MalisisGui).ifPresent(screen -> ((MalisisGui)((Object)screen)).updateGui());
        }
        super.updateGui();
    }

    @Override
    public void close() {
        BasicScreen.setFocusedComponent(null, true);
        BasicScreen.setHoveredComponent(null, true);
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.field_146297_k.field_71439_g != null && this.field_146297_k.field_71439_g.field_71070_bA != this.field_146297_k.field_71439_g.field_71069_bz) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.onClose();
        this.field_146297_k.func_147108_a((GuiScreen)Optional.ofNullable(this.parent).orElse(null));
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        try {
            long time = System.currentTimeMillis();
            UIComponent<?> component = this.getComponentAt(x, y);
            if (component != null && component.isEnabled()) {
                boolean doubleClick;
                component.setFocused(true);
                boolean regularClick = true;
                boolean bl = doubleClick = (long)button == this.lastClickButton && time - this.lastClickTime < 250L && component == this.focusedComponent;
                if (doubleClick) {
                    regularClick = !component.onDoubleClick(x, y, MouseButton.getButton(button));
                    this.lastClickTime = 0L;
                }
                if (regularClick) {
                    component.onButtonPress(x, y, MouseButton.getButton(button));
                    if (this.draggedComponent == null) {
                        this.draggedComponent = component;
                    }
                }
            } else {
                BasicScreen.setFocusedComponent(null, true);
                if (this.inventoryContainer != null && !this.inventoryContainer.getPickedItemStack().func_190926_b()) {
                    MalisisInventoryContainer.ActionType action = button == 1 ? MalisisInventoryContainer.ActionType.DROP_ONE : MalisisInventoryContainer.ActionType.DROP_STACK;
                    MalisisGui.sendAction(action, null, button);
                }
            }
            this.lastClickTime = time;
            this.lastClickButton = button;
        }
        catch (Exception e) {
            MalisisCore.message("A problem occurred : " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    @Override
    protected void func_73869_a(char keyChar, int keyCode) {
        try {
            boolean ret = false;
            for (IKeyListener listener : this.keyListeners) {
                ret |= listener.onKeyTyped(keyChar, keyCode);
            }
            if (ret) {
                return;
            }
            if (this.focusedComponent != null && !this.keyListeners.contains(this.focusedComponent) && this.focusedComponent.onKeyTyped(keyChar, keyCode)) {
                return;
            }
            if (BasicScreen.isGuiCloseKey(keyCode) && this.field_146297_k.field_71462_r == this) {
                this.close();
            }
            if (!MalisisCore.isObfEnv && BasicScreen.func_146271_m() && (BasicScreen.currentGui() != null || this.isOverlay)) {
                if (keyCode == 19) {
                    this.clearScreen();
                    this.setResolution();
                    this.construct();
                }
                if (keyCode == 32) {
                    this.debug = !this.debug;
                }
            }
        }
        catch (Exception e) {
            MalisisCore.message("A problem occurred while handling key typed for " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace(new PrintStream(new FileOutputStream(FileDescriptor.out)));
        }
    }

    public void setFocusedComponent(UIComponent<?> component) {
        this.focusedComponent = component;
    }

    public void addToScreen(UIComponent ... components) {
        Arrays.stream(components).forEach(this::addToScreen);
    }

    protected void onClose() {
    }
}

