/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.main.TotalEconomy;
import com.erigitic.util.MessageManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class AdminPayCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private MessageManager messageManager;

    public AdminPayCommand(TotalEconomy totalEconomy, AccountManager accountManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.messageManager = messageManager;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        String amountStr = (String)args.getOne("amount").get();
        User recipient = (User)args.getOne("player").get();
        Optional optCurrencyName = args.getOne("currencyName");
        Pattern amountPattern = Pattern.compile("^[+-]?(\\d*\\.)?\\d+$");
        Matcher m = amountPattern.matcher(amountStr);
        if (m.matches()) {
            BigDecimal amount = new BigDecimal((String)args.getOne("amount").get()).setScale(2, 1);
            TEAccount recipientAccount = (TEAccount)this.accountManager.getOrCreateAccount(recipient.getUniqueId()).get();
            TransactionResult transactionResult = this.getTransactionResult(recipientAccount, amount, optCurrencyName);
            if (transactionResult.getResult() == ResultType.SUCCESS) {
                LiteralText amountText = Text.of((String)transactionResult.getCurrency().format(amount).toPlain().replace("-", ""));
                HashMap<String, String> messageValues = new HashMap<String, String>();
                messageValues.put("sender", src.getName());
                messageValues.put("recipient", recipient.getName());
                messageValues.put("amount", amountText.toPlain());
                if (!amountStr.contains("-")) {
                    src.sendMessage(this.messageManager.getMessage("command.adminpay.send.sender", messageValues));
                    if (recipient.isOnline()) {
                        ((Player)recipient.getPlayer().get()).sendMessage(this.messageManager.getMessage("command.adminpay.send.recipient", messageValues));
                    }
                } else {
                    src.sendMessage(this.messageManager.getMessage("command.adminpay.remove.sender", messageValues));
                    if (recipient.isOnline()) {
                        ((Player)recipient.getPlayer().get()).sendMessage(this.messageManager.getMessage("command.adminpay.remove.recipient", messageValues));
                    }
                }
                return CommandResult.success();
            }
            throw new CommandException((Text)Text.of((String)"[TE] An error occurred while paying a player!"));
        }
        throw new CommandException((Text)Text.of((String)"[TE] Invalid amount! Must be a number!"));
    }

    private TransactionResult getTransactionResult(TEAccount recipientAccount, BigDecimal amount, Optional<String> optCurrencyName) throws CommandException {
        Cause cause = Cause.builder().append((Object)this.totalEconomy.getPluginContainer()).build(EventContext.empty());
        if (optCurrencyName.isPresent()) {
            Optional<Currency> optCurrency = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + optCurrencyName.get().toLowerCase());
            if (optCurrency.isPresent()) {
                return recipientAccount.deposit(optCurrency.get(), amount, cause);
            }
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "[TE] The specified currency does not exist!"}));
        }
        return recipientAccount.deposit(this.totalEconomy.getDefaultCurrency(), amount, cause);
    }
}

