/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.config.TECurrency;
import com.erigitic.main.TotalEconomy;
import com.erigitic.util.MessageManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.text.Text;

public class PayCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private MessageManager messageManager;

    public PayCommand(TotalEconomy totalEconomy, AccountManager accountManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.messageManager = messageManager;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        String amountStr = (String)args.getOne("amount").get();
        Player recipient = (Player)args.getOne("player").get();
        Optional optCurrencyName = args.getOne("currencyName");
        if (src instanceof Player) {
            Player sender = (Player)src;
            if (sender.getUniqueId().equals(recipient.getUniqueId())) {
                throw new CommandException((Text)Text.of((String)"[TE] You cannot pay yourself!"));
            }
            Pattern amountPattern = Pattern.compile("^[+]?(\\d*\\.)?\\d+$");
            Matcher m = amountPattern.matcher(amountStr);
            if (m.matches()) {
                TEAccount recipientAccount;
                BigDecimal amount = new BigDecimal(amountStr).setScale(2, 1);
                TEAccount senderAccount = (TEAccount)this.accountManager.getOrCreateAccount(sender.getUniqueId()).get();
                TransferResult transferResult = this.getTransferResult(senderAccount, recipientAccount = (TEAccount)this.accountManager.getOrCreateAccount(recipient.getUniqueId()).get(), amount, optCurrencyName);
                if (transferResult.getResult() == ResultType.SUCCESS) {
                    Text amountText = Text.of((Object[])new Object[]{transferResult.getCurrency().format(amount)});
                    HashMap<String, String> messageValues = new HashMap<String, String>();
                    messageValues.put("sender", src.getName());
                    messageValues.put("recipient", recipient.getName());
                    messageValues.put("amount", amountText.toPlain());
                    sender.sendMessage(this.messageManager.getMessage("command.pay.sender", messageValues));
                    recipient.sendMessage(this.messageManager.getMessage("command.pay.recipient", messageValues));
                    return CommandResult.success();
                }
                if (transferResult.getResult() == ResultType.ACCOUNT_NO_FUNDS) {
                    throw new CommandException((Text)Text.of((String)"[TE] Insufficient funds!"));
                }
                throw new CommandException((Text)Text.of((String)"[TE] An error occurred while paying another player!"));
            }
            throw new CommandException((Text)Text.of((String)"[TE] Invalid amount! Must be a positive number!"));
        }
        throw new CommandException((Text)Text.of((String)"[TE] This command can only be run by a player!"));
    }

    private TransferResult getTransferResult(TEAccount senderAccount, TEAccount recipientAccount, BigDecimal amount, Optional<String> optCurrencyName) throws CommandException {
        Cause cause = Cause.builder().append((Object)this.totalEconomy.getPluginContainer()).build(EventContext.empty());
        if (optCurrencyName.isPresent()) {
            Optional<Currency> optCurrency = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + optCurrencyName.get().toLowerCase());
            if (optCurrency.isPresent()) {
                TECurrency teCurrency = (TECurrency)optCurrency.get();
                if (teCurrency.isTransferable()) {
                    return senderAccount.transfer((Account)recipientAccount, optCurrency.get(), amount, cause);
                }
                throw new CommandException(Text.of((Object[])new Object[]{"[TE] ", teCurrency.getPluralDisplayName(), " can't be transferred!"}));
            }
            throw new CommandException((Text)Text.of((String)"[TE] The specified currency does not exist!"));
        }
        return senderAccount.transfer((Account)recipientAccount, this.totalEconomy.getDefaultCurrency(), amount, cause);
    }
}

