/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.effects;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.effects.ParticleColor;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalService;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Particle {
    private final String name;
    private final ParticleType type;
    private final long time;
    private static ThreadLocalRandom random = ThreadLocalRandom.current();

    protected Particle(String name, ParticleType type, long time) {
        this.name = name;
        this.type = type;
        this.time = time;
    }

    public String getName() {
        return this.name;
    }

    public ParticleType getType() {
        return this.type;
    }

    private long getTime() {
        return this.time;
    }

    public boolean isColorable() {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().getDefaultOption(ParticleOptions.COLOR).isPresent();
    }

    public void spawnParticle(Location<World> location, boolean player, Optional<ParticleColor> color) {
        if (this.getType() == null) {
            return;
        }
        if (ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "particles", "enable"}).getBoolean()) {
            this.spawnNonRepeat(location, player, color);
        }
    }

    public void createTask(String name, List<Location<World>> locations, Optional<ParticleColor> color) {
        if (this.getType() == null) {
            return;
        }
        if (ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "particles", "enable"}).getBoolean()) {
            this.spawnRepeat(name, locations, color);
        }
    }

    private void spawnNonRepeat(Location<World> location, boolean player, Optional<ParticleColor> color) {
        if (this.getType() == null) {
            return;
        }
        ParticleEffect particle = ParticleEffect.builder().type(this.getType()).build();
        for (int i = 0; i < 9; ++i) {
            if (this.isColorable() && color.isPresent()) {
                particle = ParticleEffect.builder().type(this.getType()).option(ParticleOptions.COLOR, (Object)color.get().getColor()).build();
            }
            if (player) {
                ((World)location.getExtent()).spawnParticles(particle, location.getPosition().add(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5));
                ((World)location.getExtent()).spawnParticles(particle, location.getPosition().add(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5));
                continue;
            }
            ((World)location.getExtent()).spawnParticles(particle, location.getPosition().add(random.nextDouble(), random.nextDouble(), random.nextDouble()));
            ((World)location.getExtent()).spawnParticles(particle, location.getPosition().add(random.nextDouble(), random.nextDouble(), random.nextDouble()));
        }
    }

    private void spawnRepeat(String name, List<Location<World>> locations, Optional<ParticleColor> color) {
        if (this.getType() == null) {
            return;
        }
        if (this.getName().equals("PORTAL2")) {
            Portal portal = ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get(locations.get(0), Portal.PortalType.PORTAL).get();
            Sponge.getScheduler().createTaskBuilder().intervalTicks(this.getTime()).name(portal.getName()).execute(t -> portal.getProperties().get().update(false)).submit((Object)Main.getPlugin());
        } else {
            Sponge.getScheduler().createTaskBuilder().interval(this.getTime(), TimeUnit.MILLISECONDS).name(name).execute(t -> {
                ParticleEffect particle = ParticleEffect.builder().type(this.getType()).build();
                for (Location location : locations) {
                    Optional optionalChunk = ((World)location.getExtent()).getChunk(location.getChunkPosition());
                    if (!optionalChunk.isPresent() || !((Chunk)optionalChunk.get()).isLoaded()) continue;
                    if (this.isColorable() && color.isPresent()) {
                        particle = ParticleEffect.builder().type(this.getType()).option(ParticleOptions.COLOR, (Object)((ParticleColor)((Object)((Object)color.get()))).getColor()).build();
                    }
                    ((World)location.getExtent()).spawnParticles(particle, location.getPosition().add(random.nextDouble(), random.nextDouble(), random.nextDouble()));
                    ((World)location.getExtent()).spawnParticles(particle, location.getPosition().add(random.nextDouble(), random.nextDouble(), random.nextDouble()));
                }
            }).submit((Object)Main.getPlugin());
        }
    }
}

