/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.listeners;

import com.flowpowered.math.vector.Vector3d;
import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjp.Main;
import com.gmail.trentech.pjp.events.ConstructPortalEvent;
import com.gmail.trentech.pjp.portal.Portal;
import com.gmail.trentech.pjp.portal.PortalBuilder;
import com.gmail.trentech.pjp.portal.PortalService;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.rotation.PlayerRotation;
import com.gmail.trentech.pjp.utils.Timings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class PortalListener {
    public static ConcurrentHashMap<UUID, Portal> builders = new ConcurrentHashMap();
    private Timings timings;
    private static List<UUID> cache = new ArrayList<UUID>();

    public PortalListener(Timings timings) {
        this.timings = timings;
    }

    @Listener
    public void onConnectionEvent(ClientConnectionEvent.Login event, @Root Player player) {
        Location location = event.getToTransform().getLocation();
        PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
        while (portalService.get((Location<World>)location, Portal.PortalType.PORTAL).isPresent() || portalService.get((Location<World>)location, Portal.PortalType.DOOR).isPresent()) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            int x = random.nextInt(6) - 3 + location.getBlockX();
            int z = random.nextInt(6) - 3 + location.getBlockZ();
            Optional optionalLocation = Sponge.getGame().getTeleportHelper().getSafeLocation(((World)location.getExtent()).getLocation(x, location.getBlockY(), z));
            if (!optionalLocation.isPresent()) continue;
            location = (Location)optionalLocation.get();
            event.setToTransform(new Transform(location));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    @Exclude(value={ChangeBlockEvent.Place.class})
    public void onInteractBlockEventSecondary(InteractBlockEvent.Secondary event, @Root Player player) {
        this.timings.onInteractBlockEventSecondary().startTiming();
        try {
            Direction direction;
            if (!builders.containsKey(player.getUniqueId())) {
                return;
            }
            Portal portal = builders.get(player.getUniqueId());
            if (player.getItemInHand(HandTypes.MAIN_HAND).isPresent()) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Hand must be empty"}));
                return;
            }
            Optional optionalLocation = event.getTargetBlock().getLocation();
            if (!optionalLocation.isPresent()) {
                return;
            }
            Location location = (Location)optionalLocation.get();
            PortalBuilder builder = new PortalBuilder(portal, (Location<World>)location, direction = PlayerRotation.getClosest(player.getRotation().getFloorY()).getDirection());
            if (!builder.spawnPortal(Cause.of((EventContext)EventContext.builder().add(EventContextKeys.CREATOR, (Object)player).build(), (Object)player))) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Not a valid portal shape"}));
                return;
            }
            builders.remove(player.getUniqueId());
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Portal ", portal.getName(), " created successfully"}));
        }
        finally {
            this.timings.onInteractBlockEventSecondary().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onConstructPortalEvent(ConstructPortalEvent event, @Root Player player) {
        this.timings.onConstructPortalEvent().startTiming();
        try {
            List<Location<World>> locations = event.getLocations();
            for (Location<World> location : event.getLocations()) {
                if (!((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get(location, Portal.PortalType.PORTAL).isPresent()) continue;
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Portals cannot over lap other portals"}));
                event.setCancelled(true);
                return;
            }
            CommentedConfigurationNode config = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig();
            int size = config.getNode(new Object[]{"options", "portal", "size"}).getInt();
            if (locations.size() > size) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Portals cannot be larger than ", size, " blocks"}));
                event.setCancelled(true);
                return;
            }
            if (locations.size() < 9) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, "Portal too small"}));
                event.setCancelled(true);
                return;
            }
        }
        finally {
            this.timings.onConstructPortalEvent().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onMoveEntityEventItem(MoveEntityEvent event, @Getter(value="getTargetEntity") Item item) {
        this.timings.onMoveEntityEvent().startTimingIfSync();
        try {
            Location location = item.getLocation();
            Optional<Portal> optionalPortal = ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get((Location<World>)location, Portal.PortalType.PORTAL);
            if (!optionalPortal.isPresent()) {
                return;
            }
            Portal portal = optionalPortal.get();
            if (portal instanceof Portal.Server) {
                return;
            }
            Portal.Local local = (Portal.Local)portal;
            if (!ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "portal", "teleport_item"}).getBoolean()) {
                return;
            }
            Optional<Coordinate> optionalCoordinate = local.getCoordinate();
            if (!optionalCoordinate.isPresent()) {
                return;
            }
            Coordinate coordinate = optionalCoordinate.get();
            Optional<Location<World>> optionalSpawnLocation = coordinate.getLocation();
            if (!optionalSpawnLocation.isPresent()) {
                return;
            }
            Location<World> spawnLocation = optionalSpawnLocation.get();
            Vector3d rotation = portal.getRotation().toVector3d();
            event.setToTransform(new Transform(spawnLocation.getExtent(), spawnLocation.getPosition(), rotation));
        }
        finally {
            this.timings.onMoveEntityEvent().stopTimingIfSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onMoveEntityEventLiving(MoveEntityEvent event, @Getter(value="getTargetEntity") Living living) {
        if (living instanceof Player) {
            return;
        }
        this.timings.onMoveEntityEvent().startTimingIfSync();
        try {
            Location location = living.getLocation();
            Optional<Portal> optionalPortal = ((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get((Location<World>)location, Portal.PortalType.PORTAL);
            if (!optionalPortal.isPresent()) {
                return;
            }
            Portal portal = optionalPortal.get();
            if (portal instanceof Portal.Server) {
                return;
            }
            Portal.Local local = (Portal.Local)portal;
            if (!ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options", "portal", "teleport_mob"}).getBoolean()) {
                return;
            }
            Optional<Coordinate> optionalCoordinate = local.getCoordinate();
            if (!optionalCoordinate.isPresent()) {
                return;
            }
            Coordinate coordinate = optionalCoordinate.get();
            Optional<Location<World>> optionalSpawnLocation = coordinate.getLocation();
            if (!optionalSpawnLocation.isPresent()) {
                return;
            }
            Location<World> spawnLocation = optionalSpawnLocation.get();
            Vector3d rotation = portal.getRotation().toVector3d();
            event.setToTransform(new Transform(spawnLocation.getExtent(), spawnLocation.getPosition(), rotation));
        }
        finally {
            this.timings.onMoveEntityEvent().stopTimingIfSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener(order=Order.FIRST)
    public void onMoveEntityEventPlayer(MoveEntityEvent event, @Getter(value="getTargetEntity") Player player) {
        this.timings.onMoveEntityEvent().startTimingIfSync();
        try {
            Location location = event.getFromTransform().getLocation();
            PortalService portalService = (PortalService)Sponge.getServiceManager().provide(PortalService.class).get();
            Optional<Portal> optionalPortal = portalService.get((Location<World>)location, Portal.PortalType.PORTAL);
            if (!optionalPortal.isPresent()) {
                return;
            }
            Portal portal = optionalPortal.get();
            UUID uuid = player.getUniqueId();
            if (cache.contains(uuid)) {
                return;
            }
            cache.add(uuid);
            portalService.execute(player, portal);
            Sponge.getScheduler().createTaskBuilder().delayTicks(20L).execute(c -> cache.remove(uuid)).submit((Object)Main.getPlugin());
        }
        finally {
            this.timings.onMoveEntityEvent().stopTimingIfSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventPlace(ChangeBlockEvent.Place event, @Root Player player) {
        this.timings.onChangeBlockEventPlace().startTiming();
        try {
            for (Transaction transaction : event.getTransactions()) {
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                if (!((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get((Location<World>)location, Portal.PortalType.PORTAL).isPresent()) continue;
                event.setCancelled(true);
                break;
            }
        }
        finally {
            this.timings.onChangeBlockEventPlace().stopTiming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Listener
    public void onChangeBlockEventBreak(ChangeBlockEvent.Break event, @Root Player player) {
        this.timings.onChangeBlockEventBreak().startTiming();
        try {
            for (Transaction transaction : event.getTransactions()) {
                Location location = (Location)((BlockSnapshot)transaction.getFinal()).getLocation().get();
                if (!((PortalService)Sponge.getServiceManager().provide(PortalService.class).get()).get((Location<World>)location, Portal.PortalType.PORTAL).isPresent()) continue;
                event.setCancelled(true);
                break;
            }
        }
        finally {
            this.timings.onChangeBlockEventBreak().stopTiming();
        }
    }
}

