/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjp.portal;

import com.gmail.trentech.pjp.data.DataQueries;
import com.gmail.trentech.pjp.portal.features.Command;
import com.gmail.trentech.pjp.portal.features.Coordinate;
import com.gmail.trentech.pjp.portal.features.Properties;
import com.gmail.trentech.pjp.rotation.Rotation;
import java.io.IOException;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.InvalidDataException;

public abstract class Portal
implements DataSerializable {
    private final PortalType type;
    private String name;
    private Rotation rotation = Rotation.EAST;
    private double price = 0.0;
    private Optional<String> permission = Optional.empty();
    private Optional<Properties> properties = Optional.empty();
    private Optional<Command> command = Optional.empty();

    protected Portal(PortalType type, Rotation rotation, double price) {
        this.type = type;
        this.rotation = rotation;
        this.price = price;
    }

    public PortalType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public Optional<Command> getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = Optional.of(command);
    }

    public Optional<String> getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = Optional.of(permission);
    }

    public Optional<Properties> getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = Optional.of(properties);
    }

    public static String serialize(Portal portal) {
        try {
            if (portal instanceof Server) {
                Server server = (Server)portal;
                return DataFormats.JSON.write((DataView)server.toContainer());
            }
            Local local = (Local)portal;
            return DataFormats.JSON.write((DataView)local.toContainer());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Portal deserialize(String portal) {
        DataContainer container;
        try {
            container = DataFormats.JSON.read(portal);
        }
        catch (IOException | InvalidDataException e) {
            e.printStackTrace();
            return null;
        }
        if (container.contains(DataQueries.SERVER)) {
            try {
                return (Portal)Sponge.getDataManager().deserialize(Server.class, (DataView)container).get();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return (Portal)Sponge.getDataManager().deserialize(Local.class, (DataView)container).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum PortalType {
        BUTTON,
        DOOR,
        HOME,
        LEVER,
        PLATE,
        PORTAL,
        SIGN,
        WARP;

    }

    public static class Local
    extends Portal {
        private Optional<Coordinate> coordinate;
        private boolean force;

        public Local(PortalType type, Rotation rotation, double price, boolean force) {
            super(type, rotation, price);
            this.force = force;
        }

        public Optional<Coordinate> getCoordinate() {
            return this.coordinate;
        }

        public void setCoordinate(Coordinate coordinate) {
            this.coordinate = Optional.of(coordinate);
        }

        public boolean force() {
            return this.force;
        }

        public void setSet(boolean force) {
            this.force = force;
        }

        public int getContentVersion() {
            return 0;
        }

        public DataContainer toContainer() {
            DataContainer container = DataContainer.createNew().set(DataQueries.PORTAL_TYPE, (Object)this.getType().name()).set(DataQueries.ROTATION, (Object)this.getRotation().getName()).set(DataQueries.PRICE, (Object)this.getPrice()).set(DataQueries.FORCE, (Object)this.force());
            if (this.getPermission().isPresent()) {
                container.set(DataQueries.PERMISSION, (Object)this.getPermission().get());
            }
            if (this.getProperties().isPresent()) {
                container.set(DataQueries.PROPERTIES, (Object)this.getProperties().get());
            }
            if (this.getCoordinate().isPresent()) {
                container.set(DataQueries.COORDINATE, (Object)this.getCoordinate().get());
            }
            if (this.getCommand().isPresent()) {
                container.set(DataQueries.COMMAND, (Object)this.getCommand().get());
            }
            return container;
        }

        public static class Builder
        extends AbstractDataBuilder<Local> {
            public Builder() {
                super(Local.class, 0);
            }

            protected Optional<Local> buildContent(DataView container) throws InvalidDataException {
                if (container.contains(DataQueries.PORTAL_TYPE, new DataQuery[]{DataQueries.ROTATION, DataQueries.PRICE})) {
                    PortalType type = PortalType.valueOf((String)container.getString(DataQueries.PORTAL_TYPE).get());
                    Rotation rotation = Rotation.get((String)container.getString(DataQueries.ROTATION).get()).get();
                    Double price = (Double)container.getDouble(DataQueries.PRICE).get();
                    boolean force = (Boolean)container.getBoolean(DataQueries.FORCE).get();
                    Local portal = new Local(type, rotation, price, force);
                    if (container.contains(DataQueries.PERMISSION)) {
                        portal.setPermission((String)container.getString(DataQueries.PERMISSION).get());
                    }
                    if (container.contains(DataQueries.COMMAND)) {
                        portal.setCommand((Command)container.getSerializable(DataQueries.COMMAND, Command.class).get());
                    }
                    if (container.contains(DataQueries.COORDINATE)) {
                        portal.setCoordinate((Coordinate)container.getSerializable(DataQueries.COORDINATE, Coordinate.class).get());
                    }
                    if (container.contains(DataQueries.PROPERTIES)) {
                        portal.setProperties((Properties)container.getSerializable(DataQueries.PROPERTIES, Properties.class).get());
                    }
                    return Optional.of(portal);
                }
                return Optional.empty();
            }
        }
    }

    public static class Server
    extends Portal {
        private String server;

        public Server(PortalType type, String server, Rotation rotation, double price) {
            super(type, rotation, price);
            this.server = server;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public int getContentVersion() {
            return 0;
        }

        public DataContainer toContainer() {
            DataContainer container = DataContainer.createNew().set(DataQueries.PORTAL_TYPE, (Object)this.getType().name()).set(DataQueries.SERVER, (Object)this.getServer()).set(DataQueries.ROTATION, (Object)this.getRotation().getName()).set(DataQueries.PRICE, (Object)this.getPrice());
            if (this.getPermission().isPresent()) {
                container.set(DataQueries.PERMISSION, (Object)this.getPermission().get());
            }
            if (this.getCommand().isPresent()) {
                container.set(DataQueries.COMMAND, (Object)this.getCommand().get());
            }
            if (this.getProperties().isPresent()) {
                container.set(DataQueries.PROPERTIES, (Object)this.getProperties().get());
            }
            return container;
        }

        public static class Builder
        extends AbstractDataBuilder<Server> {
            public Builder() {
                super(Server.class, 0);
            }

            protected Optional<Server> buildContent(DataView container) throws InvalidDataException {
                if (container.contains(DataQueries.PORTAL_TYPE, new DataQuery[]{DataQueries.SERVER, DataQueries.ROTATION, DataQueries.PRICE})) {
                    PortalType type = PortalType.valueOf((String)container.getString(DataQueries.PORTAL_TYPE).get());
                    String server = (String)container.getString(DataQueries.SERVER).get();
                    Rotation rotation = Rotation.get((String)container.getString(DataQueries.ROTATION).get()).get();
                    Double price = (Double)container.getDouble(DataQueries.PRICE).get();
                    Server portal = new Server(type, server, rotation, price);
                    if (container.contains(DataQueries.PERMISSION)) {
                        portal.setPermission((String)container.getString(DataQueries.PERMISSION).get());
                    }
                    if (container.contains(DataQueries.COMMAND)) {
                        portal.setCommand((Command)container.getSerializable(DataQueries.COMMAND, Command.class).get());
                    }
                    if (container.contains(DataQueries.PROPERTIES)) {
                        portal.setProperties((Properties)container.getSerializable(DataQueries.PROPERTIES, Properties.class).get());
                    }
                    return Optional.of(portal);
                }
                return Optional.empty();
            }
        }
    }
}

