/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui;

import fluxnetworks.FluxConfig;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.gui.EnumNavigationTabs;
import fluxnetworks.api.network.NetworkSettings;
import fluxnetworks.api.translate.FluxTranslate;
import fluxnetworks.api.utils.FluxConfigurationType;
import fluxnetworks.api.utils.NBTType;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.basic.GuiTabCore;
import fluxnetworks.client.gui.button.NormalButton;
import fluxnetworks.client.gui.button.SlidedSwitchButton;
import fluxnetworks.client.gui.button.TextboxButton;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.item.ItemConfigurator;
import fluxnetworks.common.network.PacketConfiguratorSettings;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFluxConfiguratorHome
extends GuiTabCore {
    public NormalButton apply;
    public TextboxButton fluxName;
    public TextboxButton priority;
    public TextboxButton limit;
    public SlidedSwitchButton surge;
    public SlidedSwitchButton disableLimit;
    public SlidedSwitchButton chunkLoad;
    public ItemStack stack;
    public NBTTagCompound configTag;
    public String stackCustomName;
    public int stackPriority;
    public long stackLimit;
    public boolean stackSurgeMode;
    public boolean stackDisableLimit;
    public boolean stackChunkLoading;
    private int timer;

    public GuiFluxConfiguratorHome(EntityPlayer player, ItemConfigurator.NetworkConnector connector) {
        super(player, connector);
        this.stack = connector.stack;
        this.updateSettingsFromTag();
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_HOME;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), this.network.getSetting(NetworkSettings.NETWORK_COLOR), 20, 8);
        this.func_73732_a(this.field_146289_q, TextFormatting.RED + FluxNetworks.proxy.getFeedback(false).getInfo(), 89, 150, 0xFFFFFF);
        this.field_146289_q.func_78276_b(FluxTranslate.SURGE_MODE.t(), 20, 90, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
        this.field_146289_q.func_78276_b(FluxTranslate.DISABLE_LIMIT.t(), 20, 102, this.network.getSetting(NetworkSettings.NETWORK_COLOR).intValue());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_HOME, this.navigationTabs);
        int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000;
        this.fluxName = TextboxButton.create(this, FluxTranslate.NAME.t() + ": ", 0, this.field_146289_q, 16, 28, 144, 12).setOutlineColor(color);
        this.fluxName.setMaxStringLength(24);
        this.fluxName.setText(this.stackCustomName);
        this.priority = TextboxButton.create(this, FluxTranslate.PRIORITY.t() + ": ", 1, this.field_146289_q, 16, 45, 144, 12).setOutlineColor(color).setDigitsOnly();
        this.priority.setMaxStringLength(5);
        this.priority.setText(String.valueOf(this.stackPriority));
        this.limit = TextboxButton.create(this, FluxTranslate.TRANSFER_LIMIT.t() + ": ", 2, this.field_146289_q, 16, 62, 144, 12).setOutlineColor(color).setDigitsOnly();
        this.limit.setMaxStringLength(9);
        this.limit.setText(String.valueOf(this.stackLimit));
        this.surge = new SlidedSwitchButton(140, 90, 1, this.field_147003_i, this.field_147009_r, this.stackSurgeMode);
        this.switches.add(this.surge);
        this.disableLimit = new SlidedSwitchButton(140, 102, 2, this.field_147003_i, this.field_147009_r, this.stackDisableLimit);
        this.switches.add(this.disableLimit);
        this.apply = new NormalButton(FluxTranslate.APPLY.t(), this.field_146999_f / 2 - 18, 138, 36, 12, 3);
        this.buttons.add(this.apply);
        this.apply.clickable = this.configTag == null;
        this.textBoxes.add(this.fluxName);
        this.textBoxes.add(this.priority);
        this.textBoxes.add(this.limit);
    }

    @Override
    public void onTextBoxChanged(TextboxButton text) {
        super.onTextBoxChanged(text);
        if (text == this.fluxName) {
            this.stackCustomName = this.fluxName.getText();
            this.onSettingsChanged();
        } else if (text == this.priority) {
            this.stackPriority = this.priority.getIntegerFromText(false);
            this.onSettingsChanged();
        } else if (text == this.limit) {
            this.stackLimit = Math.min(this.limit.getLongFromText(true), Long.MAX_VALUE);
            this.limit.setText(String.valueOf(this.stackLimit));
            this.onSettingsChanged();
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (button instanceof SlidedSwitchButton) {
                SlidedSwitchButton switchButton = (SlidedSwitchButton)button;
                switchButton.switchButton();
                switch (switchButton.id) {
                    case 1: {
                        this.stackSurgeMode = switchButton.slideControl;
                        this.onSettingsChanged();
                        break;
                    }
                    case 2: {
                        this.stackDisableLimit = switchButton.slideControl;
                        this.onSettingsChanged();
                        break;
                    }
                    case 3: {
                        this.stackChunkLoading = switchButton.slideControl;
                    }
                }
            }
            if (button == this.apply) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), this.network.getNetworkID());
                tag.func_74768_a(FluxConfigurationType.PRIORITY.getNBTName(), this.stackPriority);
                tag.func_74772_a(FluxConfigurationType.TRANSFER.getNBTName(), this.stackLimit);
                tag.func_74757_a(FluxConfigurationType.PRIORITY_SETTING.getNBTName(), this.stackSurgeMode);
                tag.func_74757_a(FluxConfigurationType.TRANSFER_SETTING.getNBTName(), this.stackDisableLimit);
                PacketHandler.network.sendToServer((IMessage)new PacketConfiguratorSettings.ConfiguratorSettingsMessage(this.stackCustomName, tag));
                this.stack.func_77983_a("Configs", (NBTBase)tag);
                this.updateSettingsFromTag();
                this.apply.setUnclickable();
            }
        }
    }

    public void updateSettingsFromTag() {
        this.configTag = this.stack.func_179543_a("Configs");
        if (this.configTag != null) {
            this.stackCustomName = this.stack.func_82833_r();
            this.stackPriority = this.configTag.func_74762_e(FluxConfigurationType.PRIORITY.getNBTName());
            this.stackSurgeMode = this.configTag.func_74767_n(FluxConfigurationType.PRIORITY_SETTING.getNBTName());
            this.stackLimit = this.configTag.func_74763_f(FluxConfigurationType.TRANSFER.getNBTName());
            this.stackDisableLimit = this.configTag.func_74767_n(FluxConfigurationType.TRANSFER_SETTING.getNBTName());
            this.stackChunkLoading = false;
        } else {
            this.stackCustomName = this.stack.func_82833_r();
            this.stackPriority = 0;
            this.stackSurgeMode = false;
            this.stackLimit = FluxConfig.defaultLimit;
            this.stackDisableLimit = false;
            this.stackChunkLoading = false;
        }
    }

    public void onSettingsChanged() {
        this.apply.clickable = this.configTag == null ? true : this.network.getNetworkID() != this.configTag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName()) || this.stackPriority != this.configTag.func_74762_e(FluxConfigurationType.PRIORITY.getNBTName()) || this.stackLimit != this.configTag.func_74763_f(FluxConfigurationType.TRANSFER.getNBTName()) || this.stackSurgeMode != this.configTag.func_74767_n(FluxConfigurationType.PRIORITY_SETTING.getNBTName()) || this.stackDisableLimit != this.configTag.func_74767_n(FluxConfigurationType.TRANSFER_SETTING.getNBTName()) || !this.stackCustomName.equals(this.stack.func_82833_r());
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.timer == 0) {
            PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_GENERAL));
        }
        ++this.timer;
        this.timer %= 100;
    }
}

