/*
 * Decompiled with CFR 0.152.
 */
package net.moddedminecraft.mmcrestrict.Commands;

import com.flowpowered.math.vector.Vector3i;
import net.moddedminecraft.mmcrestrict.Config.Config;
import net.moddedminecraft.mmcrestrict.Main;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.type.TileEntityInventory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;

public class Sendtochest
implements CommandExecutor {
    private final Main plugin;
    int count = 0;

    public Sendtochest(Main plugin) {
        this.plugin = plugin;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            throw new CommandException(this.plugin.fromLegacy("Only players can run this command"));
        }
        final ItemType itemType = (ItemType)args.getOne("ItemID").get();
        boolean itemFoundInWhitelist = false;
        for (String item : Config.sendToChestWhitelist) {
            if (!itemType.getId().contains(item)) continue;
            itemFoundInWhitelist = true;
        }
        if (!itemFoundInWhitelist) {
            throw new CommandException(this.plugin.fromLegacy("This item is not on the whitelist to send to a chest."));
        }
        final Player player = (Player)src;
        final Iterable loadedChunks = player.getWorld().getLoadedChunks();
        player.sendMessage(this.plugin.fromLegacy("&eSearch has started, Please wait a moment for the results."));
        Sponge.getScheduler().createAsyncExecutor((Object)this.plugin).execute(new Runnable(){

            @Override
            public void run() {
                loadedChunks.forEach(chunk -> {
                    Vector3i min = chunk.getBlockMin();
                    Vector3i max = chunk.getBlockMax();
                    for (int x = min.getX(); x <= max.getX(); ++x) {
                        for (int y = min.getY(); y <= max.getY(); ++y) {
                            for (int z = min.getZ(); z <= max.getZ(); ++z) {
                                BlockState block = chunk.getBlock(x, y, z);
                                Location blockLoc = chunk.getLocation(x, y, z);
                                if (!block.getType().getId().equals(itemType.getId())) continue;
                                Sponge.getScheduler().createTaskBuilder().execute(() -> {
                                    BlockSnapshot blockSnap = blockLoc.createSnapshot();
                                    blockLoc.setBlock(BlockTypes.CHEST.getDefaultState(), BlockChangeFlags.ALL);
                                    TileEntity chest = (TileEntity)blockLoc.getTileEntity().get();
                                    TileEntityInventory inventory = (TileEntityInventory)chest;
                                    inventory.offer(ItemStack.builder().fromBlockSnapshot(blockSnap).build());
                                    Sendtochest.this.updateCount();
                                }).submit(((PluginContainer)Sponge.getPluginManager().getPlugin("mmcrestrict").get()).getInstance().get());
                            }
                        }
                    }
                });
                player.sendMessage(Sendtochest.this.plugin.fromLegacy("&e" + Sendtochest.this.count + " blocks have been put into a chest"));
            }
        });
        return CommandResult.success();
    }

    private void updateCount() {
        ++this.count;
    }
}

