/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.helpers.FontHelper;
import sonar.core.integration.SonarLoader;

public class SonarSeeds
extends Item
implements IPlantable {
    private Block cropBlock;
    private Block soilBlock;
    public int greenhouseTier;

    public SonarSeeds(Block cropBlock, Block soilBlock, int tier) {
        this.cropBlock = cropBlock;
        this.soilBlock = soilBlock;
        this.func_77637_a(CreativeTabs.field_78035_l);
        this.greenhouseTier = tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        if (SonarLoader.calculatorLoaded()) {
            switch (this.greenhouseTier) {
                case 0: {
                    break;
                }
                case 1: {
                    list.add(FontHelper.translate("planting.basic"));
                    break;
                }
                case 2: {
                    list.add(FontHelper.translate("planting.advanced"));
                    break;
                }
                case 3: {
                    list.add(FontHelper.translate("planting.flawless"));
                }
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.greenhouseTier == 0 || !SonarLoader.calculatorLoaded()) {
            if (side != EnumFacing.UP) {
                return EnumActionResult.PASS;
            }
            if (player.func_175151_a(pos, side, stack) && player.func_175151_a(pos.func_177972_a(EnumFacing.UP), side, stack)) {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
                    world.func_175656_a(pos.func_177972_a(side), this.cropBlock.func_176223_P());
                    stack.func_190918_g(1);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.cropBlock == Blocks.field_150388_bm ? EnumPlantType.Nether : EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.cropBlock.func_176223_P();
    }

    public boolean canTierUse(int tier) {
        return tier >= this.greenhouseTier;
    }
}

