/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import cofh.redstoneflux.api.IEnergyStorage;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.EnumEnergyWrapperType;
import sonar.core.handlers.energy.IEnergyHandler;
import sonar.core.network.sync.SyncEnergyStorage;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyStorage", modid="redstoneflux")})
public class InternalEnergyStorageWrapper
implements net.minecraftforge.energy.IEnergyStorage,
IEnergyStorage,
ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
IEnergyHandler {
    public final SyncEnergyStorage storage;
    public final EnumFacing face;

    public InternalEnergyStorageWrapper(SyncEnergyStorage storage, EnumFacing face) {
        this.storage = storage;
        this.face = face;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.storage.addEnergy(maxReceive, this.face, ActionType.getTypeForAction(simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.storage.removeEnergy(maxExtract, this.face, ActionType.getTypeForAction(simulate));
    }

    public int getEnergyStored() {
        return (int)Math.min(this.storage.getEnergyLevel(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.storage.getFullCapacity(), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return this.storage.canExtract(this.face);
    }

    public boolean canReceive() {
        return this.storage.canReceive(this.face);
    }

    public long getStoredPower() {
        return this.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.getMaxEnergyStored();
    }

    public long takePower(long power, boolean simulated) {
        return this.storage.removeEnergy(Math.min(Integer.MAX_VALUE, power), this.face, ActionType.getTypeForAction(simulated));
    }

    public long givePower(long power, boolean simulated) {
        return this.storage.addEnergy(power, this.face, ActionType.getTypeForAction(simulated));
    }

    @Override
    public EnumEnergyWrapperType getWrapperType() {
        return this.face == null ? EnumEnergyWrapperType.INTERNAL_TILE_STORAGE : EnumEnergyWrapperType.EXTERNAL_TILE;
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.FE;
    }

    @Override
    public boolean canAddEnergy() {
        return this.canReceive();
    }

    @Override
    public boolean canRemoveEnergy() {
        return this.canExtract();
    }

    @Override
    public boolean canReadEnergy() {
        return true;
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    @Override
    public long addEnergy(long maxReceive, ActionType action) {
        return this.storage.addEnergy(maxReceive, this.face, action);
    }

    @Override
    public long removeEnergy(long maxExtract, ActionType action) {
        return this.storage.removeEnergy(maxExtract, this.face, action);
    }

    @Override
    public long getStored() {
        return this.getEnergyStored();
    }

    public long getEnergyLevel() {
        return this.storage.getEnergyLevel();
    }

    public long getFullCapacity() {
        return this.storage.getFullCapacity();
    }
}

