/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import sonar.core.api.inventories.ISonarInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;

public class SonarInventorySideWrapper
implements IItemHandlerModifiable {
    public final ISonarInventory inventory;
    public final EnumFacing face;

    public static NonNullList<IItemHandlerModifiable> initWrappers(ISonarInventory inventory) {
        NonNullList list = NonNullList.func_191196_a();
        for (EnumFacing face : EnumFacing.values()) {
            list.add(face.ordinal(), (Object)new SonarInventorySideWrapper(inventory, face));
        }
        list.add(6, (Object)new SonarInventorySideWrapper(inventory, null));
        return list;
    }

    public static IItemHandlerModifiable getHandlerForSide(NonNullList<IItemHandlerModifiable> list, EnumFacing face) {
        return (IItemHandlerModifiable)list.get(face == null ? 6 : face.ordinal());
    }

    public SonarInventorySideWrapper(ISonarInventory inventory, @Nullable EnumFacing face) {
        this.inventory = inventory;
        this.face = face;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.inventory.checkInsert(slot, stack, this.face, EnumFilterType.EXTERNAL)) {
            return this.inventory.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.inventory.checkExtract(slot, amount, this.face, EnumFilterType.EXTERNAL)) {
            return this.inventory.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }
}

