/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import openmods.api.IValueReceiver;
import openmods.gui.Icon;
import openmods.gui.component.GuiComponentButton;

public class GuiComponentToggleButton<T>
extends GuiComponentButton
implements IValueReceiver<T> {
    public static final int BORDER_SIZE = 4;
    private final Map<T, Icon> icons;
    private T value;

    public GuiComponentToggleButton(int x, int y, int borderColor, Map<T, Icon> icons) {
        super(x, y, GuiComponentToggleButton.getMaxWidth(icons.values()) + 4, GuiComponentToggleButton.getMaxHeight(icons.values()) + 4, borderColor);
        this.icons = ImmutableMap.copyOf(icons);
    }

    private static int getMaxWidth(Collection<Icon> icons) {
        int result = 0;
        for (Icon icon : icons) {
            result = Math.max(result, icon.width);
        }
        return result;
    }

    private static int getMaxHeight(Collection<Icon> icons) {
        int result = 0;
        for (Icon icon : icons) {
            result = Math.max(result, icon.height);
        }
        return result;
    }

    @Override
    protected void renderContents(int offsetX, int offsetY, int mouseX, int mouseY, boolean pressed) {
        int offset = this.buttonEnabled && pressed ? 3 : 2;
        Icon icon = this.icons.get(this.value);
        if (icon != null) {
            int middleX = (this.width - 4 - icon.width) / 2;
            int middleY = (this.height - 4 - icon.height) / 2;
            this.drawSprite(icon, offsetX + this.x + offset + middleX, offsetY + this.y + offset + middleY);
        }
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }
}

