/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenCherry
extends WorldGenTree {
    public WorldGenCherry(ITreeGenData tree) {
        super(tree, 4, 4);
    }

    @Override
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        int branchHeight = this.height - 1;
        int branchWidth = this.height / 2;
        while (branchHeight > 2) {
            branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, branchHeight, 0), this.girth, 0.2f, 0.5f, branchWidth, 1, 1.0f));
            branchHeight -= 2;
            ++branchWidth;
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height + 2;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1 + this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCircle(world, rand, branchEnd.func_177984_a(), 3.0f, 3, 1, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.AIR);
            WorldGenHelper.generateCircle(world, rand, branchEnd, 4.0f, 3, 1, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.AIR);
        }
    }
}

