/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.render;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.core.genetics.Genome;
import forestry.core.models.BlankModel;
import forestry.core.models.DefaultTextureGetter;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ModelUtil;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelButterflyItem
extends BlankModel {
    @Nullable
    private static IModel modelButterfly;
    private static final Cache<IAlleleButterflySpecies, IBakedModel> cache;

    public static void onModelBake(ModelBakeEvent event) {
        modelButterfly = null;
        cache.invalidateAll();
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new ButterflyItemOverrideList();
    }

    private IBakedModel bakeModel(IAlleleButterflySpecies species, float size) {
        ImmutableMap textures = ImmutableMap.of((Object)"butterfly", (Object)species.getItemTexture());
        if (modelButterfly == null) {
            try {
                modelButterfly = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry", "item/butterfly_ge"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        IModel model = modelButterfly.retexture(textures);
        IBakedModel bakedModel = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, DefaultTextureGetter.INSTANCE);
        float scale = 0.0625f;
        SimpleModelState state = ModelUtil.loadModelState(new ResourceLocation("forestry", "models/item/butterfly_ge"));
        state = new ModelStateComposition((IModelState)state, (IModelState)new SimpleModelState(ModelButterflyItem.getTransformations(size)));
        return new PerspectiveMapWrapper((IBakedModel)new TRSRBakedModel(bakedModel, -0.03125f, 0.25f - size * 0.37f, -0.03125f + size * scale, size * 1.4f), (IModelState)state);
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransformations(float size) {
        float scale = 0.0625f;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)new TRSRTransformation(new Vector3f(scale * 0.5f, scale - size / 0.75f * scale, scale * 1.25f), null, null, null));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new TRSRTransformation(new Vector3f(0.0f, scale - size / 1.0f * scale, 0.0f), null, null, null));
        builder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new TRSRTransformation(new Vector3f(0.0f, scale - size / 1.0f * scale, 0.0f), null, null, null));
        return builder.build();
    }

    static {
        cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    private class ButterflyItemOverrideList
    extends ItemOverrideList {
        public ButterflyItemOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            IAlleleButterflySpecies species = Genome.getAllele(stack, EnumButterflyChromosome.SPECIES, true, IAlleleButterflySpecies.class);
            IAlleleFloat size = Genome.getAllele(stack, EnumButterflyChromosome.SIZE, true, IAlleleFloat.class);
            Preconditions.checkNotNull((Object)species);
            Preconditions.checkNotNull((Object)size);
            IBakedModel bakedModel = (IBakedModel)cache.getIfPresent((Object)species);
            if (bakedModel == null) {
                bakedModel = ModelButterflyItem.this.bakeModel(species, size.getValue());
                cache.put((Object)species, (Object)bakedModel);
            }
            return bakedModel;
        }
    }
}

