/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl.recipe;

import WayofTime.bloodmagic.altar.AltarTier;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class RecipeBloodAltar {
    @Nonnull
    private final Ingredient input;
    @Nonnull
    private final ItemStack output;
    @Nonnull
    private final AltarTier minimumTier;
    @Nonnegative
    private final int syphon;
    @Nonnegative
    private final int consumeRate;
    @Nonnegative
    private final int drainRate;

    public RecipeBloodAltar(@Nonnull Ingredient input, @Nonnull ItemStack output, @Nonnegative int minimumTier, @Nonnegative int syphon, @Nonnegative int consumeRate, @Nonnegative int drainRate) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        Preconditions.checkArgument((minimumTier <= AltarTier.MAXTIERS ? 1 : 0) != 0, (Object)"minimumTier cannot be higher than max tier");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((consumeRate >= 0 ? 1 : 0) != 0, (Object)"consumeRate cannot be negative.");
        Preconditions.checkArgument((drainRate >= 0 ? 1 : 0) != 0, (Object)"drain cannot be negative.");
        this.input = input;
        this.output = output;
        this.minimumTier = AltarTier.values()[minimumTier];
        this.syphon = syphon;
        this.consumeRate = consumeRate;
        this.drainRate = drainRate;
    }

    @Nonnull
    public final Ingredient getInput() {
        return this.input;
    }

    @Nonnull
    public final ItemStack getOutput() {
        return this.output;
    }

    @Nonnull
    public AltarTier getMinimumTier() {
        return this.minimumTier;
    }

    @Nonnegative
    public final int getSyphon() {
        return this.syphon;
    }

    @Nonnegative
    public final int getConsumeRate() {
        return this.consumeRate;
    }

    @Nonnegative
    public final int getDrainRate() {
        return this.drainRate;
    }
}

