/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.tile.base.TileBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileBloodTank
extends TileBase {
    public static final int[] CAPACITIES = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65336, 131072, 262144, 524288};
    public int capacity;
    protected FluidTank tank;

    public TileBloodTank(int meta) {
        this.capacity = CAPACITIES[meta] * 1000;
        this.tank = new FluidTank(this.capacity);
    }

    public TileBloodTank() {
        this.capacity = CAPACITIES[0] * 1000;
        this.tank = new FluidTank(this.capacity);
    }

    @Override
    public void deserialize(NBTTagCompound tagCompound) {
        super.deserialize(tagCompound);
        this.tank.readFromNBT(tagCompound.func_74775_l("tank"));
        this.capacity = tagCompound.func_74762_e("capacity");
        this.tank.setCapacity(this.capacity);
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        super.serialize(tagCompound);
        if (this.tank.getFluidAmount() != 0) {
            tagCompound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        }
        tagCompound.func_74768_a("capacity", this.capacity);
        return tagCompound;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getClientRenderFluid() {
        if (this.tank != null && this.tank.getFluid() != null) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public float getRenderHeight() {
        if (this.tank != null && this.tank.getFluidAmount() > 0) {
            return (float)this.tank.getFluidAmount() / (float)this.getCapacity();
        }
        return 0.0f;
    }

    public int getComparatorOutput() {
        return this.tank.getFluidAmount() > 0 ? (int)(1.0 + (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity() * 14.0) : 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }
}

