/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.io.SpongeData;
import com.gmail.trentech.pjw.io.WorldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandImport
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world import").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        WorldProperties properties;
        String genType;
        String dimType;
        String worldName;
        if (arguments.equalsIgnoreCase("import")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (Sponge.getServer().getWorld(worldName).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " is already loaded"}), false);
        }
        WorldData worldData = new WorldData(worldName);
        if (!worldData.exists()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " is not a valid world"}), false);
        }
        SpongeData spongeData = new SpongeData(worldName);
        if (spongeData.exists()) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Sponge world detected"}));
            source.sendMessage(Text.builder().color(TextColors.YELLOW).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Click command for more information "))).onClick((ClickAction)TextActions.runCommand((String)"/pjw:world load")).append(new Text[]{Text.of((String)" /world load")}).build());
            return CommandResult.success();
        }
        try {
            dimType = args[1];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalDimensionType = Sponge.getRegistry().getType(DimensionType.class, dimType);
        if (!optionalDimensionType.isPresent()) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, dimType, " is not a valid DimensionType"}));
            throw new CommandException(this.getHelp().getUsageText());
        }
        DimensionType dimensionType = (DimensionType)optionalDimensionType.get();
        try {
            genType = args[2];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalGeneratorType = Sponge.getRegistry().getType(GeneratorType.class, genType);
        if (!optionalGeneratorType.isPresent()) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, genType, " is not a valid GeneratorType"}));
            throw new CommandException(this.getHelp().getUsageText());
        }
        GeneratorType generatorType = (GeneratorType)optionalGeneratorType.get();
        WorldArchetype.Builder builder = WorldArchetype.builder().dimension(dimensionType).generator(generatorType).enabled(true).keepsSpawnLoaded(true).loadsOnStartup(true);
        List modifiers = Collections.emptyList();
        if (args.length >= 4) {
            for (int i = 3; i < args.length - 3; ++i) {
                Optional optionalModifier = Sponge.getRegistry().getType(WorldGeneratorModifier.class, args[i]);
                if (!optionalModifier.isPresent()) {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, args[i], " is not a valid WorldGeneratorModifier"}));
                    throw new CommandException(this.getHelp().getUsageText());
                }
                modifiers.add(optionalModifier.get());
            }
        }
        WorldArchetype settings = builder.build(worldName, worldName);
        try {
            properties = Sponge.getServer().createWorldProperties(worldName, settings);
            properties.setGeneratorModifiers(modifiers);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Something went wrong. Check server log for details"}), false);
        }
        Sponge.getServer().saveWorldProperties(properties);
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, worldName, " imported successfully"}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("import")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                if (world.getWorldName().equalsIgnoreCase(args[0])) {
                    for (DimensionType type : Sponge.getRegistry().getAllOf(DimensionType.class)) {
                        list.add(type.getId());
                    }
                    return list;
                }
                if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(world.getWorldName());
            }
        }
        if (args.length == 2) {
            for (DimensionType type : Sponge.getRegistry().getAllOf(DimensionType.class)) {
                if (type.getId().equalsIgnoreCase(args[1])) {
                    for (GeneratorType genType : Sponge.getRegistry().getAllOf(GeneratorType.class)) {
                        list.add(genType.getId());
                    }
                    return list;
                }
                if (!type.getId().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                list.add(type.getId());
            }
        }
        if (args.length == 3) {
            for (DimensionType type : Sponge.getRegistry().getAllOf(GeneratorType.class)) {
                if (type.getId().equalsIgnoreCase(args[1])) {
                    for (WorldGeneratorModifier modType : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                        list.add(modType.getId());
                    }
                    return list;
                }
                if (!type.getId().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                list.add(type.getId());
            }
        }
        if (args.length >= 4) {
            for (DimensionType type : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                if (type.getId().equalsIgnoreCase(args[1])) {
                    for (WorldGeneratorModifier modType : Sponge.getRegistry().getAllOf(WorldGeneratorModifier.class)) {
                        list.add(modType.getId());
                    }
                    return list;
                }
                if (!type.getId().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                list.add(type.getId());
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

