/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.utils.Zip;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandRemove
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world remove").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        if (arguments.equalsIgnoreCase("remove")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (arguments.equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        Optional optionalWorld = Sponge.getServer().getWorldProperties(arguments);
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, arguments, " does not exist"}), false);
        }
        WorldProperties world = (WorldProperties)optionalWorld.get();
        if (Sponge.getServer().getWorld(world.getWorldName()).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, world.getWorldName(), " must be unloaded before you can delete"}), false);
        }
        new Zip(world.getWorldName()).save();
        try {
            if (((Boolean)Sponge.getServer().deleteWorld(world).get()).booleanValue()) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, world.getWorldName(), " deleted successfully"}));
                return CommandResult.success();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Something went wrong. Check server log for details"}), false);
        }
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Could not delete ", world.getWorldName()}));
        return CommandResult.empty();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("remove")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length != 1) {
            return list;
        }
        for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
            if (world.getWorldName().equalsIgnoreCase(args[args.length - 1])) {
                return list;
            }
            if (!world.getWorldName().toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
            list.add(world.getWorldName());
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

