/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.utils;

import com.gmail.trentech.pjw.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.spongepowered.api.Sponge;

public class Zip {
    String worldName;
    File backupDir;
    File worldDir;

    public Zip(String worldName) {
        this.worldName = worldName;
        this.backupDir = new File("backups");
        if (!this.backupDir.isDirectory()) {
            this.backupDir.mkdirs();
        }
        File savesDir = Sponge.getGame().getSavesDirectory().toFile();
        String defaultWorld = Sponge.getServer().getDefaultWorldName();
        this.worldDir = worldName.equalsIgnoreCase(defaultWorld) ? new File(savesDir, worldName) : new File(savesDir, defaultWorld + File.separator + worldName);
    }

    public void save() {
        Main.instance().getLog().info("Backing up " + this.worldName);
        String zipFile = this.backupDir.getAbsolutePath() + File.separator + this.worldName + ".zip";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            this.addDir(this.worldDir, zipOutputStream);
            zipOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addDir(File directory, ZipOutputStream zipOutputStream) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[1024];
        for (int i = 0; i < files.length; ++i) {
            int length;
            if (files[i].isDirectory()) {
                String name = files[i].getName();
                if (Sponge.getServer().getWorldProperties(name).isPresent()) continue;
                this.addDir(files[i], zipOutputStream);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(files[i]);
            String relativePath = files[i].getAbsolutePath().replace(Sponge.getGame().getSavesDirectory().toFile().getAbsolutePath(), "").replace(" ", "").replace(File.separator + Sponge.getServer().getDefaultWorldName() + File.separator, "").replace(this.worldName + File.separator, "");
            zipOutputStream.putNextEntry(new ZipEntry(relativePath));
            while ((length = fileInputStream.read(buffer)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
    }
}

