/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components.internal;

import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vswe.superfactory.components.FluidBufferElement;
import vswe.superfactory.components.internal.FluidSetting;
import vswe.superfactory.components.internal.Setting;
import vswe.superfactory.components.internal.SideSlotTarget;
import vswe.superfactory.components.internal.SlotInventoryHolder;

public class OutputFluidCounter {
    private int currentBufferTransferSize;
    private int currentTankTransferSize;
    private Setting setting;
    private boolean useWhiteList;

    public OutputFluidCounter(List<FluidBufferElement> fluidBuffer, List<SlotInventoryHolder> tanks, SlotInventoryHolder tank, Setting setting, boolean useWhiteList) {
        block6: {
            this.setting = setting;
            this.useWhiteList = useWhiteList;
            if (setting == null || !setting.isValid() || !setting.isLimitedByAmount()) break block6;
            if (useWhiteList) {
                if (tanks.get(0).isShared()) {
                    for (SlotInventoryHolder slotInventoryHolder : tanks) {
                        this.addTank(setting, slotInventoryHolder);
                    }
                } else {
                    this.addTank(setting, tank);
                }
            } else {
                for (FluidBufferElement fluidBufferElement : fluidBuffer) {
                    this.currentBufferTransferSize += fluidBufferElement.getBufferSize(setting);
                }
            }
        }
    }

    private void addTank(Setting setting, SlotInventoryHolder tankHolder) {
        int max = 0;
        for (SideSlotTarget slotSideTarget : tankHolder.getValidSlots().values()) {
            IFluidHandler tank = tankHolder.getTank(slotSideTarget.getSide());
            FluidStack temp = tank.drain(10000000, false);
            if (temp == null || !temp.getFluid().getName().equals(((FluidSetting)setting).getFluidName())) continue;
            max = Math.max(max, temp.amount);
        }
        this.currentTankTransferSize += max;
    }

    public boolean areSettingsSame(Setting setting) {
        return this.setting == null && setting == null || this.setting != null && setting != null && this.setting.getId() == setting.getId();
    }

    public int retrieveItemCount(int desiredItemCount) {
        if (this.setting == null || !this.setting.isLimitedByAmount()) {
            return desiredItemCount;
        }
        int itemsAllowedToBeMoved = this.useWhiteList ? this.setting.getAmount() - this.currentTankTransferSize : this.currentBufferTransferSize - this.setting.getAmount();
        return Math.min(itemsAllowedToBeMoved, desiredItemCount);
    }

    public void modifyStackSize(int itemsToMove) {
        if (this.useWhiteList) {
            this.currentTankTransferSize += itemsToMove;
        } else {
            this.currentBufferTransferSize -= itemsToMove;
        }
    }
}

