/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client;

import erogenousbeef.bigreactors.client.BRRenderTickHandler;
import erogenousbeef.bigreactors.client.ClientReactorFuelRodsLayout;
import erogenousbeef.bigreactors.client.CommonBlockIconManager;
import erogenousbeef.bigreactors.client.renderer.RendererReactorFuelRod;
import erogenousbeef.bigreactors.client.renderer.RotorSpecialRenderer;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.CommonProxy;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.ReactorFuelRodsLayout;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.gui.BeefGuiIconManager;
import erogenousbeef.bigreactors.init.BrFluids;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static BeefGuiIconManager GuiIcons;
    public static CommonBlockIconManager CommonBlockIcons;
    public static long lastRenderTime;

    public ClientProxy() {
        GuiIcons = new BeefGuiIconManager();
        CommonBlockIcons = new CommonBlockIconManager();
    }

    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        super.onPreInit(event);
    }

    @Override
    public void onInit(FMLInitializationEvent event) {
        super.onInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new BRRenderTickHandler());
        this.registerTESRs();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        this.registerFluidTextures(map, BrFluids.fluidSteam);
        this.registerFluidTextures(map, BrFluids.fluidFuelColumn);
        GuiIcons.registerIcons(map);
        CommonBlockIcons.registerIcons(map);
    }

    private void registerTESRs() {
        if (!BigReactors.CONFIG.disableReactorFuelRodRender) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityReactorFuelRod.class, (TileEntitySpecialRenderer)new RendererReactorFuelRod());
        }
        if (!BigReactors.CONFIG.disableTurbineRotorRender) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurbineRotorBearing.class, (TileEntitySpecialRenderer)new RotorSpecialRenderer());
        }
    }

    private void registerFluidTextures(TextureMap map, Fluid fluid) {
        map.func_174942_a(fluid.getStill());
        map.func_174942_a(fluid.getFlowing());
    }

    @Override
    public void temp_sendPlayerStatusMessage(@Nonnull EntityPlayer player, @Nonnull ITextComponent message) {
        Minecraft.func_71410_x().field_71456_v.func_175188_a(message, false);
    }

    @Override
    @Nonnull
    public ReactorFuelRodsLayout createReactorFuelRodsLayout(@Nonnull MultiblockReactor reactor) {
        return new ClientReactorFuelRodsLayout(reactor);
    }

    static {
        lastRenderTime = Minecraft.func_71386_F();
    }
}

